<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Product\Repository\ProductGiftRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\Routing\Annotation\Route;
use CpCreation\VitiCore\Product\Model\ProductGift;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_GIFT')")
 * Class GiftController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/gift")
 */
class GiftController extends AbstractController
{
    private $giftRepository;

    public function __construct(ProductGiftRepository $giftRepository)
    {
        $this->giftRepository = $giftRepository;
    }


    /**
     * @Route("",name="admin_gift")
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $gifts = $this->giftRepository->findAll();

        return $this->render('admin/gift/index.html.twig',[
            'gifts' => $gifts
        ]);
    }

    /**
     * @Route("/{id}/disable",name="admin_gift_disable")
     * @return void
     */
    public function disableAction(ProductGift $gift)
    {
        $gift->setUsedAt(new \DateTime("now"));
        $this->giftRepository->save($gift);
        $this->giftRepository->flush();

        return $this->redirectToRoute('admin_gift');
    }
}