<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Command;

use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Product\Model\ProductType;
use CpCreation\VitiCore\Product\Repository\ProductTypeRepository;
use Fidry\AliceDataFixtures\Persistence\PurgeMode;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\Finder\Finder;

class FixtureUpdateV3Command extends Command implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    private $productTypeRepository;

    public function __construct(ProductTypeRepository $productTypeRepository) {
        parent::__construct();
        $this->productTypeRepository = $productTypeRepository;
    }

    protected function configure()
    {
        $this->setName('viti-core:update-prod:v3');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);

        $productTypes = $this->productTypeRepository->findAll();
        /**
         * @var ProductType $productType
         */
        foreach ($productTypes as $productType)
        {
            $productType->setEquivalencyManu($productType->getEquivalency());
        }

        /** @var Contact $contact */
        $files = [];
        foreach (Finder::create()->in(__DIR__.'/../../../../fixtures/update/v3')->getIterator() as $file) {
            $io->comment($file);
            $files[] = $file;
        }

        $loader = $this->container->get('fidry_alice_data_fixtures.loader.doctrine');
        $loader->load($files,[],[],PurgeMode::createNoPurgeMode());


        $io->comment('Update Ficxture for V3');

        return Command::SUCCESS;
    }
}
