<?php
/**
 * @author Colinet Julien
 */

declare(strict_types=1);

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;

trait SoftDeletable
{
    /**
     * @ORM\Column(type="datetime_immutable", nullable=true)
     *
     * @var ?\DateTimeImmutable
     */
    private $deletedAt = null;

    public function markDeleted(): void
    {
        $this->deletedAt = new \DateTimeImmutable();
    }

    public function UnMarkDeleted(): void
    {
        $this->deletedAt = null;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getDeletedAt(): ?\DateTimeImmutable
    {
        return $this->deletedAt;
    }
}