<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior\Impl;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Intl\Intl;
use Symfony\Component\Validator\Constraints as Assert;

trait Geocodable
{
    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $address;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $postal;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $city;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $country;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $lat;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $lng;

    /**
     * @return string
     */
    public function getAddress(): ?string
    {
        return $this->address;
    }

    /**
     * @param string $address
     */
    public function setAddress(?string $address)
    {
        $this->address = $address;
    }

    /**
     * @return string
     */
    public function getPostal(): ?string
    {
        return $this->postal;
    }

    /**
     * @param string $postal
     */
    public function setPostal(?string $postal)
    {
        $this->postal = str_replace(' ', '', $postal);
    }

    /**
     * @return string
     */
    public function getCity(): ?string
    {
        return $this->city;
    }

    /**
     * @param string $city
     */
    public function setCity(?string $city)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @param string $country
     */
    public function setCountry(string $country = null)
    {
        $this->country = $country;
    }

    /**
     * @return string
     */
    public function getLat(): ?string
    {
        return $this->lat;
    }

    /**
     * @param string $lat
     */
    public function setLat(string $lat = null): void
    {
        $this->lat = $lat;
    }

    /**
     * @return string
     */
    public function getLng(): ?string
    {
        return $this->lng;
    }

    /**
     * @param string $lng
     */
    public function setLng(string $lng = null): void
    {
        $this->lng = $lng;
    }

    /**
     * @return null|string
     */
    public function getCountryName(): ?string
    {
        if (!$this->getCountry()) {
            return null;
        }

        return Intl::getRegionBundle()->getCountryName($this->getCountry());
    }
}