new Swiper('.swiper-header', {
    spaceBetween: 30,
    effect: 'fade',
    speed: 1000,
    pagination: false,
    navigation: false,
    autoplay: {
        delay: 6000,
    }
});

let el = document.querySelector('.shop-isotope');
if (el) {
    let numItems = $('.swiper-slide').length;
    let numSlide = 4;
    if (numItems < 4)
    {
        numSlide = numItems;
    }
    let swiperCategory = new Swiper('.swiper-category', {
        slidesPerView: numSlide,
        loop: false,
        preventClicks: true,
        preventClicksPropagation: false,
        breakpoints: {
            1024: {
                slidesPerView: numSlide-1,
            },
            768: {
                slidesPerView: numSlide-1,
            },
            640: {
                slidesPerView: numSlide-2,
            },
            480: {
                slidesPerView: numSlide-2,
            }
        },
        //loopFillGroupWithBlank: true,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            dynamicBullets: true,
        },
        onClick: function(sw, e) {
            e.preventDefault();
        },
        onTap: function(sw, e) {
            e.preventDefault();
            sw.allowClick = false;
        }
    });
}


$( ".slide-images" ).each(function( index ) {
    new Swiper($(this), {
        loop: false,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            dynamicBullets: true,
        },
    });
});

new Swiper('.swiper-room', {
    spaceBetween: 30,
    effect: 'fade',
    speed: 1000,
    pagination: false,
    navigation: false,
    autoplay: {
        delay: 4000,
    }
});