"use strict";

let popup = document.querySelector('#popupNews');
if (popup) {
    let popupReveal = new Foundation.Reveal($('#popupNews'));
    let popupId = popup.getAttribute('data-id');
    if (typeof(Storage) !== "undefined") {
        let popupStorage = JSON.parse(localStorage.getItem('popup'));
        if (popupStorage != null) {
            if (popupStorage['view'] == true && popupStorage['time'] < new Date().getTime()) {
                popupStorage['time'] = new Date().getTime();
                localStorage.setItem('popup', JSON.stringify(popupStorage));
                popupReveal.open();
            }
            if (popupStorage['id'] != popupId) {
                popupStorage['view'] = true;
                popupStorage['id'] = popupId;
                localStorage.setItem('popup', JSON.stringify(popupStorage));
                popupReveal.open();
            }
        } else {
            let popupStorage = {'id': popupId, 'view': true, 'time': new Date().getTime()};
            localStorage.setItem('popup', JSON.stringify(popupStorage));
            popupReveal.open();
        }
    }
    
    $(".popup-hide").on("click", function () {
        let popupStorage = JSON.parse(localStorage.getItem('popup'));
        popupStorage['view'] = false;
        localStorage.setItem('popup', JSON.stringify(popupStorage));
        popupReveal.close();
    });

    $(".popup-close").on("click", function () {
        let popupStorage = JSON.parse(localStorage.getItem('popup'));
        popupStorage['time'] = new Date().getTime() + 86400000;
        localStorage.setItem('popup', JSON.stringify(popupStorage));
        popupReveal.close();
    });

}