import loadGoogleMapsApi from 'load-google-maps-api';

let mapContact = document.querySelector('#map');
if (mapContact)
{
    let lat = parseFloat(mapContact.getAttribute('data-lat'));
    let lng = parseFloat(mapContact.getAttribute('data-lng'));
    let optionsObserver = {
        threshold: 0.1,
        rootMargin: '0px 0px 0px 0px'
    };
    let observer = new IntersectionObserver( (entries, observer)  => {
        entries.forEach((entry) => {
            if (entry.isIntersecting) {
                loadGoogleMapsApi({key: process.env.APP_GOOGLEMAP}).then((googleMaps) => {
                    let map = new googleMaps.Map(mapContact, {
                        center: {
                            lat: 46.8619641,
                            lng: 1.6578633
                        },
                        styles: [
                            {
                                "featureType": "administrative",
                                "elementType": "labels.text.fill",
                                "stylers": [
                                    {
                                        "color": "#444444"
                                    }
                                ]
                            },
                            {
                                "featureType": "landscape",
                                "elementType": "all",
                                "stylers": [
                                    {
                                        "color": "#f2f2f2"
                                    }
                                ]
                            },
                            {
                                "featureType": "poi",
                                "elementType": "all",
                                "stylers": [
                                    {
                                        "visibility": "off"
                                    }
                                ]
                            },
                            {
                                "featureType": "road",
                                "elementType": "all",
                                "stylers": [
                                    {
                                        "saturation": -100
                                    },
                                    {
                                        "lightness": 45
                                    }
                                ]
                            },
                            {
                                "featureType": "road.highway",
                                "elementType": "all",
                                "stylers": [
                                    {
                                        "visibility": "simplified"
                                    }
                                ]
                            },
                            {
                                "featureType": "road.arterial",
                                "elementType": "labels.icon",
                                "stylers": [
                                    {
                                        "visibility": "off"
                                    }
                                ]
                            },
                            {
                                "featureType": "transit",
                                "elementType": "all",
                                "stylers": [
                                    {
                                        "visibility": "off"
                                    }
                                ]
                            },
                            {
                                "featureType": "water",
                                "elementType": "all",
                                "stylers": [
                                    {
                                        "color": "#cfcfcf"
                                    },
                                    {
                                        "visibility": "on"
                                    }
                                ]
                            }
                        ],
                        zoom: 6,
                        disableDefaultUI: true,
                    });
                    let myLatlng = new google.maps.LatLng(lat, lng);

                    new google.maps.Marker({
                        position: myLatlng,
                        map: map,
                        icon: {
                            url: '/images/picto-map-domaine.svg',
                            size: new google.maps.Size(45,45),
                            optimized: false
                        }

                    });

                    let markers = [];
                    document.querySelectorAll('.depot').forEach((depot) => {
                        let lng = depot.getAttribute('data-lng');
                        let lat = depot.getAttribute('data-lat');
                        let name = depot.getAttribute('data-name');
                        let image = '/images/picto-map-8.png';

                        let marker = new google.maps.Marker({
                            position: new google.maps.LatLng(lat, lng),
                            animation: google.maps.Animation.DROP,
                            map: map,
                            optimized: false,
                            icon: {
                                url: image,
                                size: new google.maps.Size(33, 33),
                                optimized: false
                            }
                        });

                        marker.infowindow = new google.maps.InfoWindow();
                        marker.infowindow.setContent(name);
                        marker.addListener('click', function () {
                            marker.infowindow.open(map, marker);
                        });

                        markers.push(marker);
                    });
                });
                observer.unobserve(mapContact);
            }
        });
    },  optionsObserver);

    observer.observe(mapContact);
}

/* À utiliser pour styliser la map du domaine lorsqu'il n'y a pas de dépots, salons... */

/*/!*loadGoogleMapsApi(options).then(function (googleMaps) {
let myLatlng = new google.maps.LatLng(lat_company, lng_company);
            let company = querySelector.getAttribute('data-company');
            let company_address = querySelector.getAttribute('data-address');
            let logo = "/images/logo_CD_n.svg";
            let image = "/images/img-map-contact.jpg";

            let contentString =
                '<div id="content">' +
                '<div id="bodyContent">' +
                "<img src=" + logo + " alt='' style='width: 100px;'>" +
                "<p>" + company_address +"</p>" +
                "<img src=" + image + " alt='' style='width: 200px;'>" +
                "<p class='button-map'><a href='#contact'>Nous contacter</a></p>" +
                "</div>" +
                "</div>";

            var marker_company = new google.maps.Marker({
                position: myLatlng,
                map: map,
                title: company,
                icon: {
                    url: '/images/picto-map-8.png',
                    size: new google.maps.Size(35, 35),
                    optimized: false
                }

            });
            var infowindow = new google.maps.InfoWindow({
                content: contentString,
                size: new google.maps.Size(100, 100)
            });

            infowindow.open(map, marker_company);
            marker_company.setMap(map);

});
*!*/
