import {Calendar} from '@fullcalendar/core';
import fr from '@fullcalendar/core/locales/fr';
import nl from '@fullcalendar/core/locales/nl';
import en from '@fullcalendar/core/locales/en-gb';
import googleCalendarPlugin from '@fullcalendar/google-calendar';
import dayGridPlugin from '@fullcalendar/daygrid';
import listPlugin from '@fullcalendar/list';
import loadGoogleMapsApi from "load-google-maps-api";

document.addEventListener('DOMContentLoaded', () =>  {
    let calendarEl = document.querySelector('#calendar1');
    let optionsObserver = {
        threshold: 0.1,
        rootMargin: '0px 0px 0px 0px'
    };
    if (calendarEl){
        let lang = fr;
        let langAttribute = document.querySelector('html').getAttribute('lang');
        switch (langAttribute) {
            case 'fr':
                lang = fr;
                break;
            case 'en':
                lang = en;
                break;
            case 'nl':
                lang = nl;
                break;
            default:
                lang = en;
        }
        let observer = new IntersectionObserver( (entries, observer)  => {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    let calendar = new Calendar(calendarEl, {
                        locale: lang,
                        contentHeight: 550,
                        plugins: [googleCalendarPlugin, dayGridPlugin, listPlugin],
                        initialView: 'dayGridMonth',
                        googleCalendarApiKey: process.env.GOOGLE_CALENDAR_KEY,
                        events: {
                            googleCalendarId: process.env.GOOGLE_CALENDAR_KEY,
                            backgroundColor: process.env.GOOGLE_CALENDAR_BACKGROUND,
                            borderColor: process.env.GOOGLE_CALENDAR_BACKGROUND,
                            textColor: process.env.GOOGLE_CALENDAR_TEXT
                        },
                    });

                    calendar.render();
                    observer.unobserve(calendarEl);
                }
            });
        },  optionsObserver);

        observer.observe(calendarEl);
    }
});
