import 'intersection-observer';
import lozad from "lozad";

export default{
    init() {
        this.pictureLozads = document.querySelectorAll('.lozad[data-height]');
        this.containerImagesLozads = document.querySelectorAll('[data-lozad-container]');
        this.pictureLozads.forEach(picture => {
            let ratio = 1;
            let sources = picture.querySelectorAll('source');
            let valid = false;
            if (picture.classList.contains("loaded")) {
                picture.style.minHeight = "";
            } else {

                if (sources.length > 0) {
                    sources.forEach(source => {
                        if (((window.matchMedia(source.getAttribute('media')).matches) && valid === false) ) {
                            let forceHeight = source.getAttribute('data-force-height');
                            if (forceHeight) {
                                picture.style.minHeight = forceHeight + 'px';
                            } else {
                                let width = source.getAttribute('data-width');
                                let height = source.getAttribute('data-height');
                                let maxWidth = source.getAttribute('data-max-width');
                                if (width && height) {
                                    ratio = width / height;
                                    let containerWidth = picture.offsetWidth;
                                    if (maxWidth !== null) {
                                        if (containerWidth >= width) {
                                            picture.style.minHeight = height + 'px';
                                        } else {
                                            picture.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                        }
                                    } else {
                                        picture.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                    }
                                }
                            }
                            valid = true;
                        }
                    });
                }
            }
        });
        this.containerImagesLozads.forEach(containerImage => {
                let ratio = 1;
                let imgs = containerImage.querySelectorAll('img');
                if (imgs.length > 0) {
                    imgs.forEach(img => {
                        if (img.classList.contains("loaded")) {
                            img.style.minHeight = "";
                        } else {
                            let width = img.getAttribute('data-width');
                            let height = img.getAttribute('data-height');
                            let maxWidth = img.getAttribute('data-max-width');
                            if (width && height) {
                                ratio = width / height;
                                let containerWidth = containerImage.offsetWidth;
                                if (maxWidth !== null) {
                                    if (containerWidth >= width) {
                                        img.style.minHeight = height + 'px';
                                    } else {
                                        img.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                    }
                                } else {
                                    img.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                }
                            }
                        }
                    })
                }
            }
        );
    },
    observe()
    {
        let observer = lozad('.lozad', {
            rootMargin: '300px 0px 300px 0px',
            threshold: 0.1, // ratio of element convergence
            loaded: (el) => {
                el.classList.add('loaded');
                let imageBefore = this._getNextSibling(el, '.before-lozad');
                if (imageBefore) {
                    imageBefore.classList.add('no-view');
                }

            }
        });

        observer.observe();
    },

    _getNextSibling(elem, selector) {

        // Get the next sibling element
        var sibling = elem.nextElementSibling;

        // If there's no selector, return the first sibling
        if (!selector) return sibling;

        // If the sibling matches our selector, use it
        // If not, jump to the next sibling and continue the loop
        while (sibling) {
            if (sibling.matches(selector)) return sibling;
            sibling = sibling.nextElementSibling
        }

    }
}
