import loadGoogleMapsApi from "load-google-maps-api";

/* SUBMENU & ARTICLES ACTIVE */

let linkEvent = document.querySelector('.link-event');
let listEvents = document.querySelectorAll('.list-event');

function removeActiveCategory() {
    listEvents.forEach(function () {
        $('.link-event').removeClass("active");
        $('.list-event').removeClass("category-active");
    });
}

$('.link-event').on('click', function (e) {
    removeActiveCategory();
    e.preventDefault();
    let slug = e.target.getAttribute("data-category");
    $('.link-event[data-category="'+slug+'"]').addClass("active");
    $('.list-event[data-category="'+slug+'"]').addClass("category-active");
});

/* AFFICHAGE CARTE AU CLICK */

let depot_link = $(".depot_link");
let buttonCloseContactForm = $('.button_close');

depot_link.on('click', function (e) {
    e.preventDefault();
    $('.depot_map').css('display', 'block');
    $('.depot_map').css('z-index', '1');
    $('body.find-us').css('overflow', 'hidden');
});

buttonCloseContactForm.on('click', function () {
    $('.depot_map').css('display', 'none');
    $('.depot_map').css('z-index', '0');
    $('body.find-us').css('overflow', '');
});

/* OPTIONS CARTE GOOGLE MAP */

let options = {key: process.env.APP_GOOGLEMAP};
let depotContainers = document.querySelectorAll('.depot-container');
let mapsGoogle = [];
if (depotContainers) {
    depotContainers.forEach(function(container, index) {
        loadGoogleMapsApi(options).then(function (googleMaps) {
            mapsGoogle[index] = (new googleMaps.Map(container.querySelector('.depotMap'), {
                center: {lat: 46.8619641, lng: 1.6578633},
                zoom: 6,
                disableDefaultUI: true,
                styles: [
                    {
                        "featureType": "all",
                        "elementType": "labels.text.fill",
                        "stylers": [
                            {
                                "saturation": 36
                            },
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 40
                            }
                        ]
                    },
                    {
                        "featureType": "all",
                        "elementType": "labels.text.stroke",
                        "stylers": [
                            {
                                "visibility": "on"
                            },
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 16
                            }
                        ]
                    },
                    {
                        "featureType": "all",
                        "elementType": "labels.icon",
                        "stylers": [
                            {
                                "visibility": "off"
                            }
                        ]
                    },
                    {
                        "featureType": "administrative",
                        "elementType": "geometry.fill",
                        "stylers": [
                            {
                                "lightness": 20
                            },
                            {
                                "visibility": "on"
                            }
                        ]
                    },
                    {
                        "featureType": "administrative",
                        "elementType": "geometry.stroke",
                        "stylers": [
                            {
                                "color": "#b3b3b3"
                            },
                            {
                                "lightness": 17
                            },
                            {
                                "weight": 1.2
                            }
                        ]
                    },
                    {
                        "featureType": "landscape",
                        "elementType": "geometry",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 20
                            }
                        ]
                    },
                    {
                        "featureType": "poi",
                        "elementType": "geometry",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 21
                            }
                        ]
                    },
                    {
                        "featureType": "road.highway",
                        "elementType": "geometry.fill",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 17
                            },
                            {
                                "visibility": "off"
                            }
                        ]
                    },
                    {
                        "featureType": "road.highway",
                        "elementType": "geometry.stroke",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 29
                            },
                            {
                                "weight": 0.2
                            },
                            {
                                "visibility": "off"
                            }
                        ]
                    },
                    {
                        "featureType": "road.arterial",
                        "elementType": "geometry",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 18
                            }
                        ]
                    },
                    {
                        "featureType": "road.local",
                        "elementType": "geometry",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 16
                            }
                        ]
                    },
                    {
                        "featureType": "transit",
                        "elementType": "geometry",
                        "stylers": [
                            {
                                "color": "#000000"
                            },
                            {
                                "lightness": 19
                            }
                        ]
                    },
                    {
                        "featureType": "water",
                        "elementType": "geometry",
                        "stylers": [
                            {
                                "color": "#1f1f1f"
                            }
                        ]
                    }
                ]
            }));
            let markers = [];
            container.querySelectorAll('div.depot').forEach(function (depot) {
                let lng = depot.getAttribute('data-lng');
                let lat = depot.getAttribute('data-lat');
                let name = depot.getAttribute('data-name');
                let marker = new google.maps.Marker({
                    position: new google.maps.LatLng(lat,lng),
                    animation: google.maps.Animation.DROP,
                    map: mapsGoogle[index],
                    optimized: false,
                    icon: {
                        url: process.env.ICON_MAP,
                        size: new google.maps.Size(50, 50),
                        optimized: false
                    }
                });
                marker.infowindow = new google.maps.InfoWindow();
                marker.infowindow.setContent(name);
                marker.addListener('click', function () {
                    marker.infowindow.open(mapsGoogle[index], marker);
                });
                markers.push(marker);
            });
        });
    });

}
