import SmoothScroll from "smooth-scroll";

let submenuList = $('.submenu-list');
let navSubmenu = $('.navSubmenu-open');

$(function () {
    $('#navSubmenu').prop('checked', false);
    navSubmenu.removeClass('open');
    navSubmenu.addClass('close');
});

navSubmenu.on('click', function () {
    if (navSubmenu.hasClass('open')) {
        submenuList.css('display', 'none');
        navSubmenu.removeClass('open');
        navSubmenu.addClass('close');
    } else {
        submenuList.css('display', 'block');
        navSubmenu.removeClass('close');
        navSubmenu.addClass('open');
    }
});

let arrowUp = document.querySelector('.submenu-command .prevArticle');
let arrowDown = document.querySelector('.submenu-command .nextArticle');
if (arrowUp) {
    arrowUp.addEventListener('click', function (event) {
        event.preventDefault();
        let submenuLinkActive = document.querySelector('.submenu-list a.active');
        let index = parseFloat(submenuLinkActive.getAttribute('data-index'));
        index = index - 1;
        submenuLinkActive = document.querySelector('.submenu-list a[data-index="' + index + '"]');
        if (submenuLinkActive == null) {
            submenuLinkActive = document.querySelector('.submenu-list a[data-end]');
        }
        let scrollTo = document.querySelector(submenuLinkActive.getAttribute('href'));
        let scroll = new SmoothScroll();
        let options = {speed: 800, easing: 'easeOutCubic', header: '#navbar', offset: 30};
        scroll.animateScroll(scrollTo, null, options);

        return false;
    });
}

if (arrowDown) {
    arrowDown.addEventListener('click', function (event) {
        event.preventDefault();
        let submenuLinkActive = document.querySelector('.submenu-list a.active');
        let index = parseFloat(submenuLinkActive.getAttribute('data-index'));
        index = index + 1;
        submenuLinkActive = document.querySelector('.submenu-list a[data-index="' + index + '"]');
        if (submenuLinkActive == null) {
            submenuLinkActive = document.querySelector('.submenu-list a[data-begin]');
        }
        let scrollTo = document.querySelector(submenuLinkActive.getAttribute('href'));
        let scroll = new SmoothScroll();
        let options = {speed: 800, easing: 'easeOutCubic', header: '#navbar', offset: 30};
        scroll.animateScroll(scrollTo, null, options);

        return false;
    });
}
