let el = document.getElementById('nav');
let nav = $('nav label');
let navContainer = $('.nav-container');
let submenu = $('.sub-menu');
let submenuCommand = $('.submenu-command');
let submenuList = $('.submenu-list');

$(function () {
    $('#nav').prop('checked', false);
    $('body').css('overflow', '');
    nav.removeClass('open');
    nav.addClass('close');
});

$('ul li a', navContainer).on('click', function () {
    $('input[id=nav]').prop('checked', false);
    $('body').css('overflow', '');
    nav.removeClass('open');
    nav.addClass('close');
});

nav.on('click', function () {
    if (nav.hasClass('open')) {
        $('body').css('overflow', '');
        navContainer.css('display','none');
        nav.removeClass('open');
        nav.addClass('close');
        submenu.css('z-index','1');
    } else {
        $('body').css('overflow', 'hidden');
        navContainer.css('display','block');
        nav.removeClass('close');
        nav.addClass('open');
        submenu.css('z-index','-1');
    }
});

if (document.querySelector('.sub-menu:not([data-ignore-scroll])')){
    let articles = $('article')
        , sticky = $('.sub-menu')
        , nav_height = nav.outerHeight();

    let subMenuListA = $('.submenu-list a');
    subMenuListA.removeClass('active');
    submenuCommand.css({'opacity':'0', 'visibility':'hidden'});
    submenuList.css({'opacity':'0', 'visibility':'hidden'});

    $(window).on('scroll', function () {
        let cur_pos = $(this).scrollTop();
        submenuCommand.css({'opacity':'1', 'visibility':'visible'});
        submenuList.css({'opacity':'1', 'visibility':'visible'});
        articles.each(function() {
            let top = $(this).offset().top - nav_height,
                bottom = top + $(this).outerHeight();
            if (cur_pos + 150  >= top && cur_pos + 150 <= bottom) {
                sticky.find('a').removeClass('active');
                sticky.find('a[href="#'+$(this).attr('id')+'"]').addClass('active ');
            }
        });
        if(cur_pos == 0){
            submenuCommand.css({'opacity':'0', 'visibility':'hidden'});
            submenuList.css({'opacity':'0', 'visibility':'hidden'});
        }
    });
}