let showMoreList = document.querySelectorAll('.show-more-list');

showMoreList.forEach((showMore) => {
    showMore.addEventListener('click', function (event) {
        event.preventDefault();
        let active = false;
        let divGroup = showMore.parentNode.querySelector('.category-group-content');
        if (divGroup.classList.contains('active')) {
            active = true;
        }
        showMoreList.forEach((showMore) => {
            let divGroupElem = showMore.parentNode.querySelector('.category-group-content');
            if (divGroupElem.classList.contains('active')) {
                showMore.querySelector('span').innerHTML = showMore.querySelector('a').getAttribute('data-text-open');
                divGroupElem.classList.remove('active');
                divGroupElem.removeAttribute('style');
            }
        });
        let textOpen = event.target.getAttribute('data-text-open');
        let textClose = event.target.getAttribute('data-text-close');
        if (active) {
            divGroup.removeAttribute('style');
            event.target.querySelector('span').innerHTML = textOpen;
        } else {
            var scrollTop     = $(window).scrollTop(),
                elementOffset = divGroup.offsetTop,
                distance      = (scrollTop  - elementOffset);
            divGroup.classList.add('active');
            event.target.querySelector('span').innerHTML = textClose;
            setTimeout(function(){
                divGroup.style.maxHeight = divGroup.offsetHeight + "px";
            }, 200);

        }
    }, false);
});

function isInViewport(el) {
    const rect = el.getBoundingClientRect();
    return (
        rect.top >= document.querySelector('#navbar').offsetHeight &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)

    );
}
