<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Locale\Repository\LocaleRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class VerifyController extends AbstractController
{
    private $localeRepository;

    public function __construct(LocaleRepository $localeRepository)
    {
        $this->localeRepository = $localeRepository;
    }

    /**
     * @Route({
     *     "fr": "/verification-age",
     *     "en": "/en/check-age"
     * }, name="verify")
     *
     * @Template("@CpCreationTheme2/verify.html.twig")
     */
    public function indexAction()
    {
        $locales  = $this->localeRepository->findAll();

        return [
            'locales' => $locales
        ];
    }
}