<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\PaymentType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\PaymentProviderManager;
use CpCreation\VitiCore\Cart\Repository\PaymentMethodRepository;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Payment\Model\Payment;
use CpCreation\VitiCore\Payment\Repository\PaymentRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class PaymentController
 * @package CpCreation\Theme2Bundle\Controller
 */
class PaymentController extends AbstractController
{
    private $paymentRepository;
    private $paymentProviderManager;
    private $contactRepository;
    private $paymentMethodRepository;

    public function __construct(PaymentRepository $paymentRepository,
        PaymentProviderManager $paymentProviderManager,
        ContactRepository $contactRepository,
        PaymentMethodRepository $paymentMethodRepository
    ) {
        $this->paymentRepository       = $paymentRepository;
        $this->paymentProviderManager  = $paymentProviderManager;
        $this->contactRepository       = $contactRepository;
        $this->paymentMethodRepository = $paymentMethodRepository;
    }


    /**
     * @param Request $request
     *
     * @Route({
     *     "fr": "/paiement-en-ligne",
     *     "en": "/en/secure-payment"
     * }, name="payment")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|Response
     */
    public function indexAction(Request $request)
    {
        $form = $this->createForm(PaymentType::class);
        $form->handleRequest($request);
        $paymentMethod = $this->paymentMethodRepository->findByDefaultForPaymentOnline();

        if (!$paymentMethod) {
            throw new \Exception("Méthode de paiement inexistant pour le système de paiement en ligne");
        }
        if ($form->isSubmitted()) {
            if ($form->isValid()) {
                /** @var Payment $data */
                $payment = $form->getData();
                $this->paymentRepository->save($payment);
                $contact = $this->contactRepository->findOne();

                return $this->paymentProviderManager->createPaymentProviderManager($contact, $payment);
            } else {
                $this->addFlash('error', 'Le formulaire n\'est pas rempli correctement !');
            }
        }

        return $this->render(
            '@CpCreationTheme2/payment.html.twig',
            [
                'form'          => $form->createView(),
                'paymentMethod' => $paymentMethod,
            ]
        );
    }

    /**
     * @param Request $request
     * @param Payment $payment
     *
     * @Route({
     *     "fr": "/paiement-en-ligne/{id}",
     *     "en": "/en/secure-payment/{id}"
     * }, name="payment_item")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|Response
     */
    public function itemAction(Request $request, Payment $payment)
    {
        $form = $this->createForm(PaymentType::class, $payment);
        $form->handleRequest($request);
        $paymentMethod = $this->paymentMethodRepository->findByDefaultForPaymentOnline();

        return $this->render(
            '@CpCreationTheme2/payment.html.twig',
            [
                'form'          => $form->createView(),
                'paymentMethod' => $paymentMethod,
            ]
        );
    }
}
