<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Behavior\HasPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\PaymentProviderManager;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\EtransactionsPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\MoneticoPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\SherlockPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\SogeCommercePayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\SystemPayPayment;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\Payment\Sherlock;
use CpCreation\VitiCore\Cart\Repository\CartRepository;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Payment\Model\Payment;
use CpCreation\VitiCore\Payment\Repository\PaymentRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;

class MethodPaymentController extends AbstractController
{
    private $cartRepository;
    private $paymentRepository;
    private $contactRepository;
    private $paymentProviderManager;
    private $etransactionsPayment;
    private $moneticoPayment;
    private $systempay;
    private $sherlockPayment;
    private $sogeCommercePayment;
    private $sherlockDir;
    private $translator;
    private $session;

    public function __construct(
        CartRepository $cartRepository,
        PaymentRepository $paymentRepository,
        ContactRepository $contactRepository,
        PaymentProviderManager $paymentProviderManager,
        EtransactionsPayment $etransactionsPayment,
        array $sherlockDir,
        MoneticoPayment $moneticoPayment,
        SystemPayPayment $systempay,
        SherlockPayment $sherlockPayment,
        SogeCommercePayment $sogeCommercePayment,
        TranslatorInterface $translator,
        SessionInterface $session
    ) {
        $this->cartRepository         = $cartRepository;
        $this->paymentRepository      = $paymentRepository;
        $this->contactRepository      = $contactRepository;
        $this->paymentProviderManager = $paymentProviderManager;
        $this->etransactionsPayment   = $etransactionsPayment;
        $this->moneticoPayment        = $moneticoPayment;
        $this->systempay              = $systempay;
        $this->sherlockPayment        = $sherlockPayment;
        $this->sogeCommercePayment    = $sogeCommercePayment;
        $this->sherlockDir            = $sherlockDir;
        $this->translator             = $translator;
        $this->session                = $session;
    }

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route("/paiement/{id}/check", name="payment_check")
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function paymentCheckAction(Request $request,
        Cart $cart,
        SessionInterface $session
    ) {
        return $this->render(
            '@CpCreationTheme2/payment/check.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $cart,
            ]
        );
    }

    /**
     * @param Request    $request
     * @param HasPayment $payment
     * @Route("/paiement/{id}/etransactions", name="payment_cb_etransactions")
     * @Route("/paiement/{id}/etransactions", name="payment_etransactions")
     * @ParamConverter("payment", converter="haspayment_converter")
     *
     * @return \Symfony\Component\HttpFoundation\Response|null
     */
    public
    function paymentEtransactionsAction(Request $request,
        HasPayment $payment
    ) {
        $data = $this->etransactionsPayment->createData($payment);
        $view = "cb.html.twig";
        $this->session->set('payment', 'Cart');
        if ($payment instanceof Payment) {
            $view = "payment.html.twig";
            $this->session->set('payment', 'Payment');
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'cart'      => $payment,
                'data'      => $data,
            ]
        );
    }

    /**
     * @param Request $request
     * @Route("/paiement/cb/retour", name="payment_cb_return")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function paymentCbReturnAction(Request $request
    ) {
        $code  = $request->query->get('Erreur');
        $ref   = $request->query->get('Ref');
        $error = null;
        $view  = "cb_return.html.twig";
        if ($code === '00000') {
            $msg = $this->translator->trans('shop.return.success');
            if ($this->session->get('payment') === "Payment") {
                $msg  = $this->translator->trans('payment.success');
                $view = "payment_return.html.twig";
            }
        } else {
            $msg   = $this->translator->trans('shop.return.echec');
            $error = $this->translator->trans('shop.return.error');
            if ($this->session->get('payment') === "Payment") {
                $msg   = $this->translator->trans('payment.echec');
                $error = $this->translator->trans('payment.error');
                $view  = "payment_return.html.twig";
            }
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }

    /**
     * @param Request    $request
     * @param HasPayment $payment
     * @Route("/paiement/{id}/cb_monetico", name="payment_cb_monetico")
     * @Route("/paiement/{id}/cb_monetico", name="payment_monetico")
     * @ParamConverter("payment", converter="haspayment_converter")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function paymentCbMoneticoAction(Request $request,
        HasPayment $payment
    ) {
        $data = $this->moneticoPayment->createData($payment);
        $view = "cb.html.twig";
        $this->session->set('payment', 'Cart');
        if ($payment instanceof Payment) {
            $view = "payment.html.twig";
            $this->session->set('payment', 'Payment');
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'cart'      => $payment,
                'data'      => $data,
            ]
        );
    }

    /**
     * @param Request $request
     * @Route("/paiement/cb_monetico/retour/erreur", name="payment_cb_monetico_return_error")
     * @Route("/paiement/cb_monetico/retour/erreur", name="payment_monetico_return_error")
     * @Route("/paiement/systempay/retour/erreur", name="payment_systempay_return_error")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function paymentCbReturnErrorAction(Request $request
    ) {
        $view  = "cb_return.html.twig";
        $msg   = $this->translator->trans('shop.return.echec');
        $error = $this->translator->trans('shop.return.error');
        if ($this->session->get('payment') === "Payment") {
            $msg   = $this->translator->trans('payment.echec');
            $error = $this->translator->trans('payment.error');
            $view  = "payment_return.html.twig";
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }

    /**
     * @param Request $request
     * @Route("/paiement/cb_monetico/retour/success", name="payment_cb_monetico_return_success")
     * @Route("/paiement/cb_monetico/retour/success", name="payment_monetico_return_success")
     * @Route("/paiement/systempay/retour/success", name="payment_systempay_return_success")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public
    function paymentCbReturnSuccessAction(Request $request
    ) {
        $error = null;
        $msg   = $this->translator->trans('shop.return.success');
        $view  = "cb_return.html.twig";
        if ($this->session->get('payment') === "Payment") {
            $msg  = $this->translator->trans('payment.success');
            $view = "payment_return.html.twig";
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }

    /**
     * @param Request    $request
     * @param HasPayment $payment
     * @Route("/paiement/{id}/sherlock", name="payment_cb_sherlock")
     * @Route("/paiement/{id}/sherlock", name="payment_sherlock")
     * @ParamConverter("payment", converter="haspayment_converter")
     *
     * @return \Symfony\Component\HttpFoundation\Response|null
     */
    public
    function paymentSherlockAction(Request $request,
        HasPayment $payment
    ) {
        $data     = [];
        $params   = $this->sherlockPayment->createData($payment);
        $path_bin = $this->sherlockDir['sherlock_request_path'];
        $result   = exec("$path_bin $params");
        $doc      = new \DOMDocument();
        $doc->loadHTML($result);
        $form        = $doc->getElementsByTagName('form');
        $formString  = $form->item(0)->ownerDocument->saveXML($form->item(0));
        $data['URL'] = $form->item(0)->attributes->getNamedItem('action')->textContent;
        $inputs      = $form->item(0)->getElementsByTagName('input');
        for ($i = 0; $i < $inputs->length; $i++) {
            if ($inputs->item($i)->attributes->getNamedItem('name')->textContent === 'DATA') {
                $data[$inputs->item($i)->attributes->getNamedItem('name')->textContent] = $inputs->item($i)->attributes->getNamedItem('value')->textContent;
            }
        }
        $view = "cb.html.twig";
        $this->session->set('payment', 'Cart');
        if ($payment instanceof Payment) {
            $view = "payment.html.twig";
            $this->session->set('payment', 'Payment');
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'cart'      => $payment,
                'data'      => $data,
            ]
        );
    }

    /**
     * @param Request    $request
     * @param HasPayment $payment
     * @Route("/paiement/{id}/cb_systempay", name="payment_cb_systempay")
     * @Route("/paiement/{id}/cb_systempay", name="payment_systempay")
     * @ParamConverter("payment", converter="haspayment_converter")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentSystemPay(Request $request, HasPayment $payment)
    {
        $data = $this->systempay->createData($payment);
        $view = "cb.html.twig";
        $this->session->set('payment', 'Cart');
        if ($payment instanceof Payment) {
            $view = "payment.html.twig";
            $this->session->set('payment', 'Payment');
        }

        return $this->render(
            '@CpCreationTheme2/payment/cb.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $payment,
                'data'      => $data,
            ]
        );
    }

    /**
     * @param Request    $request
     * @param HasPayment $payment
     * @Route("/paiement/{id}/cb_sogecommerce", name="payment_cb_sogecommerce")
     * @Route("/paiement/{id}/cb_sogecommerce", name="payment_sogecommerce")
     * @ParamConverter("payment", converter="haspayment_converter")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */

    public
    function paymentCbSogeCommerceAction(Request $request,
        HasPayment $payment
    ) {
        $data = $this->sogeCommercePayment->createData($payment);
        $view = "cb.html.twig";
        $this->session->set('payment', 'Cart');
        if ($payment instanceof Payment) {
            $view = "payment.html.twig";
            $this->session->set('payment', 'Payment');
        }

        return $this->render(
            '@CpCreationTheme2/payment/'.$view,
            [
                'classMenu' => 'black',
                'cart'      => $payment,
                'data'      => $data,
            ]
        );
    }

}
