<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Gite\Repository\GiteRepository;
use CpCreation\VitiCore\Locale\Repository\LocaleRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class MenuController extends AbstractController
{
    private $giteRepository;
    private $localeRepository;

    public function __construct(GiteRepository $giteRepository, LocaleRepository $localeRepository)
    {
        $this->giteRepository   = $giteRepository;
        $this->localeRepository = $localeRepository;
    }

    /**
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $cottages = $this->giteRepository->findAll();
        $locales  = $this->localeRepository->findAll();

        return $this->render(
            '@CpCreationTheme2/_menu.html.twig',
            [
                'locales'  => $locales,
                'cottages' => $cottages,
            ]
        );
    }
}