<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class LegalController extends AbstractController
{

    private $contactRepository;

    public function __construct(ContactRepository $contactRepository)
    {
        $this->contactRepository = $contactRepository;
    }

    /**
     * @Route({
     *     "fr": "/mentions-legales",
     *     "en": "/en/legals-mentions"
     * }, name="legals")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $contact = $this->contactRepository->findOne();

        return $this->render(
            '@CpCreationTheme2/legal.html.twig',
            [
                'contact'   => $contact
            ]
        );
    }
}