<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\History\Repository\HistoryRepository;
use CpCreation\VitiCore\Popup\Repository\PopupRepository;
use CpCreation\VitiCore\Gite\Repository\GiteRepository;
use CpCreation\VitiCore\Newsletter\Repository\NewsletterRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class HomepageController extends AbstractController
{

    private $popupRepository;
    private $newsletterRepository;
    private $historyRepository;
    private $giteRepository;

    public function __construct(PopupRepository $popupRepository,
        NewsletterRepository $newsletterRepository,
        GiteRepository $giteRepository,
        HistoryRepository $historyRepository
    ) {
        $this->popupRepository      = $popupRepository;
        $this->newsletterRepository = $newsletterRepository;
        $this->giteRepository       = $giteRepository;
        $this->historyRepository = $historyRepository;
    }

    /**
     * @Route({
     *     "fr": "/",
     *     "en": "/en/"
     * }, name="homepage")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $popup      = $this->popupRepository->findOneOrNull();
        $newsletter = $this->newsletterRepository->findLastNewsletter();
        $cottages   = $this->giteRepository->findAll();
        $histories = $this->historyRepository->findBy(['disabled' => 0], ['position' => 'ASC']);

        $subMenu    = null;
        if ($newsletter) {
            $subMenu = true;
        }

        return $this->render(
            '@CpCreationTheme2/homepage.html.twig',
            [
                'popup'      => $popup,
                'newsletter' => $newsletter,
                'cottages'   => $cottages,
                "histories" => $histories,
                'subMenu'    => $subMenu,
            ]
        );
    }
}