<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Contact\Repository\LabelRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class FooterController extends AbstractController
{
    private $contactRepository;
    private $labelRepository;

    public function __construct(ContactRepository $contactRepository, LabelRepository $labelRepository)
    {
        $this->contactRepository = $contactRepository;
        $this->labelRepository = $labelRepository;
    }

    /**
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $contact = $this->contactRepository->findOne();
        $labels  = $this->labelRepository->findBy([], ['position' => 'ASC']);

        return $this->render(
            '@CpCreationTheme2/_footer.html.twig',
            [
                'contact' => $contact,
                'labels'  => $labels,
            ]
        );
    }
}