<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Depot\Repository\CategoryRepository;
use CpCreation\VitiCore\Event\Repository\EventRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DepotSalonController extends AbstractController
{
    private $categoryRepository;
    private $eventRepository;

    public function __construct(CategoryRepository $categoryRepository, EventRepository $eventRepository)
    {
        $this->categoryRepository = $categoryRepository;
        $this->eventRepository = $eventRepository;
    }

    /**
     * @param Request $request
     *
     *  * @Route({
     *     "fr": "/ou-nous-trouver",
     *     "en": "/en/where-to-find-us"
     * }, name="find-us")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        $categories = $this->categoryRepository->findBy([], ['position' => 'ASC']);
        $salons     = $this->eventRepository->findBy(['disabled' => false], ['beginAt' => 'ASC']);

        return $this->render(
            '@CpCreationTheme2/depotsalon.html.twig',
            [
                'categories' => $categories,
                'salons'     => $salons,
            ]
        );
    }

}