<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme2Bundle\Controller;

use CpCreation\VitiCore\Gite\Model\Gite;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Component\Routing\Annotation\Route;

class CottageController extends AbstractController
{
    /**
     * @param Gite $gite
     *
     * @Route({
     *     "fr": "/gite/{slug}",
     *     "en": "/en/gite/{slug}"
     * }, name="cottage")
     * @ParamConverter("gite", converter="translation_converter")
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Gite $gite)
    {
        return $this->render(
            '@CpCreationTheme2/cottage.html.twig',
            [
                'cottage'   => $gite
            ]
        );
    }
}