import 'core-js/stable';
import 'regenerator-runtime/runtime';
import 'element-matches-polyfill';
import 'unorm';
import Isotope from 'isotope-layout';

let el = document.querySelector('.shop-isotope');
let title = document.querySelector('.shop-title-category');
let description = document.querySelector('.shop-description-category');
let lastFilterClicked = null;
let $lastFiltersClicked = null;
let firstFilters;
let qsRegex;
let filterValue;
let categoryInProgress;
let categoryDescriptionInProgress;
let sortBy;
let categories = document.querySelectorAll('.category-filter-item');
if (el) {
    document.body.addEventListener('Isotope', function (e) {
        e.preventDefault();

        var iso = new Isotope('.shop-isotope', {
            itemSelector: '.element-item',
            transitionDuration: '0.3s',
            hiddenStyle: {
                opacity: 0
            },
            visibleStyle: {
                opacity: 1
            },
            getSortData: {
                number: '[data-order] parseInt'
            },
            sortBy: ['number']
        });
        firstFilters = document.querySelectorAll('.category-filter-item[data-first]');
        if (firstFilters.length > 0)
        {
            filterValue = firstFilters[0].getAttribute('data-filter');
            categoryInProgress = firstFilters[0].getAttribute('data-name');
            categoryDescriptionInProgress = firstFilters[0].getAttribute('data-description');
        }else{
            filterValue = "*";
        }

        iso.arrange({
            filter: function (itemElem) {
                if (itemElem.classList.contains(filterValue) || filterValue == "*") {
                    return itemElem;
                }
            },
        });
        categories.forEach((category) => {
            category.addEventListener('click', (e) => {
                e.preventDefault();
                let $this = e.target;
                document.querySelector('.quicksearch').value = "";
                filterValue = $this.getAttribute('data-filter');
                categoryInProgress = $this.getAttribute('data-name');
                categoryDescriptionInProgress = $this.getAttribute('data-description');
                title.innerHTML = categoryInProgress;
                description.innerHTML = categoryDescriptionInProgress;
                if (!lastFilterClicked) {
                    firstFilters.forEach((firstFilter) => {
                        firstFilter.classList.remove('category-filter-active');
                        firstFilter.classList.remove('active');
                    });
                } else {
                    let id = lastFilterClicked.getAttribute('data-id')
                    $lastFiltersClicked = document.querySelectorAll('.category-filter-item[data-id=' + id + ']');
                    $lastFiltersClicked.forEach((lastFilterClicked) => {
                        lastFilterClicked.classList.remove('category-filter-active');
                        lastFilterClicked.classList.remove('active');
                    });
                }
                let id = $this.getAttribute('data-id');
                let $currentsClicked = document.querySelectorAll('.category-filter-item[data-id=' + id + ']');
                $currentsClicked.forEach(($currentClicked) => {
                    $currentClicked.classList.add('category-filter-active');
                    $currentClicked.classList.add('active');
                });

                if (filterValue === "favorite") {
                    sortBy = ['number']
                } else {
                    sortBy = ''
                }

                iso.arrange({
                    filter: function (itemElem) {
                        if (!lastFilterClicked) {
                            itemElem.classList.remove('no-visible')
                        }
                        if (itemElem.classList.contains(filterValue) || filterValue === '*') {
                            return itemElem;
                        }
                    },
                    sortBy: sortBy
                });
                lastFilterClicked = $this;
                return false;
            });
        });
        // use value of search field to filter
        var $quicksearch = $('.quicksearch').keyup(function () {
            let val = $quicksearch.val();
            qsRegex = new RegExp(val.normalize("NFD").replace(/[\u0300-\u036f]/g, ""), 'gi');
            if (val == "") {
                title.innerHTML = categoryInProgress;
                description.innerHTML = categoryDescriptionInProgress;
                title.classList.remove("active");

                if (filterValue === "favorite") {
                    sortBy = ['number']
                } else {
                    sortBy = ''
                }
                iso.arrange({
                    filter: function (itemElem) {
                        if (itemElem.classList.contains(filterValue) || filterValue === '*') {
                            return itemElem;
                        }
                    },
                    sortBy: sortBy
                });
            } else {
                title.classList.add("active");

                title.innerHTML = Translator.trans('shop.searchInProgress', {}, 'messages');
                description.innerHTML = "";
                iso.arrange({
                    filter: function (itemElem) {
                        itemElem.classList.remove('no-visible')
                        return itemElem;
                    }
                });
                iso.arrange({
                    filter: function (itemElem) {
                        let optionContent = "";
                        let qualityContent = "";
                        if (itemElem.querySelector('.variant-type')) {
                            optionContent = itemElem.querySelector('.variant-type').textContent.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
                        }
                        if (itemElem.querySelector('.variant-name')) {
                            optionContent = itemElem.querySelector('.variant-name').textContent.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
                        }
                        if (itemElem.querySelector('span.quality')) {
                            qualityContent = itemElem.querySelector('span.quality').textContent.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
                        }
                        let textContent = itemElem.querySelector('.name').textContent.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
                        if (textContent.match(qsRegex) || optionContent.match(qsRegex) || qualityContent.match(qsRegex)) {

                            return itemElem;
                        }
                    },
                    sortBy: ''
                });
            }
        });
    }, false);


}
