<?php

namespace CpCreation\Theme1Bundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class CpCreationTheme1Extension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yaml');
    }

    public function prepend(ContainerBuilder $container)
    {
        $package = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config/packages'));
        $bundles = $container->getParameter('kernel.bundles');

        if (isset($bundles['LiipImagineBundle'])) {
            $package->load('imagine.yaml');
        }
        if (isset($bundles['TwigBundle'])) {
            $package->load('twig.yaml');
        }
    }
}
