import 'core-js/stable';
import 'regenerator-runtime/runtime';
import 'intersection-observer';
import 'custom-event-polyfill';

import lozad from 'lozad';

let el = document.querySelector('.shop-isotope');
if (el) {

    window.dispatchEvent(new window.CustomEvent('Isotope'))
    if (MutationObserver) {

        // If the browser running the tests doesn't support MutationObserver,
        // fall back to polling.
        if (!('MutationObserver' in window)) {
            IntersectionObserver.prototype.POLL_INTERVAL =
                IntersectionObserver.prototype.THROTTLE_TIMEOUT || 100;
        }

    }
    let getNextSibling = function (elem, selector) {

        // Get the next sibling element
        var sibling = elem.nextElementSibling;

        // If there's no selector, return the first sibling
        if (!selector) return sibling;

        // If the sibling matches our selector, use it
        // If not, jump to the next sibling and continue the loop
        while (sibling) {
            if (sibling.matches(selector)) return sibling;
            sibling = sibling.nextElementSibling
        }

    };

    /** Pour éviter un saut lorsque l'on defile de bas en haut. De plus le dom est formé avec les bonnes dimensions **/
    function pictureMinHeightDefault() {
        let pictureLozads = document.querySelectorAll('.lozad[data-height]');
        let containerImagesLozads = document.querySelectorAll('[data-lozad-container]');
        pictureLozads.forEach(picture => {
            let ratio = 1;
            let sources = picture.querySelectorAll('source');
            let exist = false;
            if (picture.classList.contains("loaded")) {
                picture.style.minHeight = "";
            } else {
                if (sources.length > 0) {
                    sources.forEach(source => {
                        if ((window.matchMedia(source.getAttribute('media')).matches) && exist === false) {
                            let forceHeight = source.getAttribute('data-force-height');
                            if (forceHeight) {
                                picture.style.minHeight = forceHeight + 'px';
                            } else {
                                let width = source.getAttribute('data-width');
                                let height = source.getAttribute('data-height');
                                let maxWidth = source.getAttribute('data-max-width');
                                if (width && height) {
                                    ratio = width / height;
                                    let containerWidth = picture.offsetWidth;
                                    if (maxWidth !== null) {
                                        if (containerWidth >= width) {
                                            picture.style.minHeight = height + 'px';
                                        } else {
                                            picture.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                        }
                                    } else {
                                        picture.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                    }
                                }
                            }
                            exist = true;
                        }
                    });
                }
            }
        });
        containerImagesLozads.forEach(containerImage => {
                let ratio = 1;
                let imgs = containerImage.querySelectorAll('img');
                if (imgs.length > 0) {
                    imgs.forEach(img => {
                        if (img.classList.contains("loaded")) {
                            img.style.minHeight = "";
                        } else {
                            let width = img.getAttribute('data-width');
                            let height = img.getAttribute('data-height');
                            let maxWidth = img.getAttribute('data-max-width');
                            if (width && height) {
                                ratio = width / height;
                                let containerWidth = containerImage.offsetWidth;
                                if (maxWidth !== null) {
                                    if (containerWidth >= width) {
                                        img.style.minHeight = height + 'px';
                                    } else {
                                        img.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                    }
                                } else {
                                    img.style.minHeight = Math.round(((containerWidth / ratio) * 100) / 100) + 'px';
                                }
                            }
                        }
                    })
                }
            }
        );

    }

    pictureMinHeightDefault();
    document.body.dispatchEvent(new CustomEvent('Isotope'));

    window.onresize = function (event) {
        pictureMinHeightDefault();
    };

    const observer = lozad('.lozad', {
        rootMargin: '300px 0px 200px 0px', // 200px pour que l'image se charge correctement lorsque nous defilons du haut en bas pour ne pas avoir de saccade lors du chargement de la photo
        threshold: [0, 0, 0, 0], // ratio of element convergence
        loaded: function (el) {
            // Custom implementation on a loaded element
            el.classList.add('loaded');
            let imageBefore = getNextSibling(el, '.before-lozad');
            if (imageBefore) {
                imageBefore.classList.add('no-view');
            }

        }
    });
    observer.observe();

}
