import Foundation from 'foundation-sites';
import $ from "jquery";
(function () {
    let panelTriggers = document.getElementsByClassName('js-cd-panel-trigger');
    let panel = document.getElementsByClassName('cd-panel');
    if (panelTriggers.length > 0) {
        for (let i = 0; i < panelTriggers.length; i++) {
            (function (i) {
                let panelClass = 'js-cd-panel-' + panelTriggers[i].getAttribute('data-panel'),
                    panel = document.getElementsByClassName(panelClass)[0];
                // open panel when clicking on trigger btn
                panelTriggers[i].addEventListener('click', function (event) {
                    $('body').css('overflow', 'hidden');
                    event.preventDefault();
                    panel.style.opacity = 1;
                    document.getElementById('cd-panel-title').innerText = panelTriggers[i].getAttribute('data-title');
                    document.getElementById('cd-panel-content').innerHTML = panelTriggers[i].getAttribute('data-text');
                    //panel.innerText = panelTriggers[i].getAttribute('data-title');
                    addClass(panel, 'cd-panel--is-visible');
                    $(document).foundation();
                    let swiperImagesShop = new Swiper('.slide-images-shop', {
                        loop: false,
                        pagination: {
                            el: '.swiper-pagination-shop',
                            dynamicBullets: true,
                        },
                    });
                });
                //close panel when clicking on 'x' or outside the panel
                panel.addEventListener('click', function (event) {
                    if (hasClass(event.target, 'js-cd-close') || hasClass(event.target, panelClass)) {
                        event.preventDefault();
                        $('body').css('overflow', '');
                        removeClass(panel, 'cd-panel--is-visible');
                    }
                });
            })(i);
        }
    }

    //class manipulations - needed if classList is not supported
    //https://jaketrent.com/post/addremove-classes-raw-javascript/
    function hasClass(el, className) {
        if (el.classList) return el.classList.contains(className);
        else return !!el.className.match(new RegExp('(\\s|^)' + className + '(\\s|$)'));
    }

    function addClass(el, className) {
        if (el.classList) el.classList.add(className);
        else if (!hasClass(el, className)) el.className += " " + className;
    }

    function removeClass(el, className) {
        if (el.classList) el.classList.remove(className);
        else if (hasClass(el, className)) {
            let reg = new RegExp('(\\s|^)' + className + '(\\s|$)');
            el.className = el.className.replace(reg, ' ');
        }
    }
})();
