import Isotope from 'isotope-layout';

let el = document.querySelector('.shop-isotope');
let title = document.querySelector('.shop-title-category');
let lastFilterClicked;

if (el) {
    var iso = new Isotope('.shop-isotope', {
        itemSelector: '.element-item'
    })

    $('.filter-button-group').on('click', 'li', function () {
        let filterValue = $(this).attr('data-filter');
        title.innerHTML = $(this).attr('data-name');
        if(lastFilterClicked != undefined)
        {
            lastFilterClicked[0].classList.remove('category-filter-active');
        }
        lastFilterClicked = $(this);
        $(this).addClass('category-filter-active');
        iso.arrange({
            filter: function (itemElem) {
                if (itemElem.classList.contains(filterValue) || filterValue === '*') {
                    return itemElem;
                }
            }
        })
    });

    $('.arrow-shop').on('click', function(e)
    {
        e.preventDefault();
        let groupFilter = $('.filter-button-group')[0];
        let arrow = $(this)[0];
        if(arrow.classList.contains('arrow-shop-right')){
            arrow.classList.remove('arrow-shop-right');
            arrow.classList.add('arrow-shop-down');
            groupFilter.style.display = "inline";
        } else {
            arrow.classList.remove('arrow-shop-down');
            arrow.classList.add('arrow-shop-right');
            groupFilter.style.display = "none";
        }
    })
}

window.onresize = function() {
    if(window.innerWidth >= 970){
        $('.filter-button-group')[0].style.display = "inline";
    } else {
        let arrowClass = $('.arrow-shop')[0].classList;
        arrowClass.remove('arrow-shop-down');
        arrowClass.add('arrow-shop-right');
        $('.filter-button-group')[0].style.display = "none";
    }
}

