<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme1Bundle\Controller;

use CpCreation\VitiCore\Season\Repository\SeasonRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class SeasonController extends AbstractController
{
    private $seasonRepository;

    public function __construct(SeasonRepository $seasonRepository)
    {
        $this->seasonRepository = $seasonRepository;
    }

    /**
     * @Route({
     *     "fr": "/saisons",
     *     "en": "/en/seasons"
     * }, name="seasons")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Exception
     */
    public function indexAction()
    {
        $seasons = $this->seasonRepository->findBy([],['position' => 'ASC']);

        return $this->render(
            '@CpCreationTheme1/season.html.twig',
            [
                'classMenu' => 'black',
                'seasons'     => $seasons
            ]
        );
    }
}