<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme1Bundle\Controller;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\CartType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\PaymentProviderManager;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\EtransactionsPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Payment\MoneticoPayment;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CalculShipping;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\PriceGroupWithCookie;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartCheckout;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Cart\Repository\CartRepository;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Product\Repository\ProductTaxRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingConfigRepository;
use CpCreation\VitiCore\Shop\Repository\ShippingCountryRepository;
use CpCreation\VitiCore\Shop\Repository\ShopConfigRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormError;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Flash\FlashBagInterface;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;

class ShopController extends AbstractController
{
    private $productPriceCodeRepository;
    private $productPriceGroupRepository;
    private $productTaxRepository;
    private $shippingCountryRepository;
    private $shopConfigRepository;
    private $shippingConfigRepository;
    private $cartRepository;
    private $contactRepository;
    private $calculShipping;
    private $priceGroupWithCookie;
    private $paymentProviderManager;
    private $etransactionsPayment;
    private $moneticoPayment;
    private $session;
    private $flashBag;
    private $translator;

    public function __construct(ProductPriceCodeRepository $productPriceCodeRepository,
        ProductPriceGroupRepository $productPriceGroupRepository,
        ProductTaxRepository $productTaxRepository,
        ShippingCountryRepository $shippingCountryRepository,
        ShopConfigRepository $shopConfigRepository,
        ShippingConfigRepository $shippingConfigRepository,
        CartRepository $cartRepository,
        ContactRepository $contactRepository,
        CalculShipping $calculShipping,
        PriceGroupWithCookie $priceGroupWithCookie,
        PaymentProviderManager $paymentProviderManager,
        EtransactionsPayment $etransactionsPayment,
        MoneticoPayment $moneticoPayment,
        SessionInterface $session,
        FlashBagInterface $flashBag,
        TranslatorInterface $translator
    ) {
        $this->productPriceCodeRepository  = $productPriceCodeRepository;
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productTaxRepository        = $productTaxRepository;
        $this->shippingCountryRepository   = $shippingCountryRepository;
        $this->shopConfigRepository        = $shopConfigRepository;
        $this->shippingConfigRepository    = $shippingConfigRepository;
        $this->cartRepository              = $cartRepository;
        $this->contactRepository           = $contactRepository;
        $this->calculShipping              = $calculShipping;
        $this->paymentProviderManager      = $paymentProviderManager;
        $this->etransactionsPayment        = $etransactionsPayment;
        $this->moneticoPayment             = $moneticoPayment;
        $this->priceGroupWithCookie        = $priceGroupWithCookie;
        $this->session                     = $session;
        $this->flashBag                    = $flashBag;
        $this->translator                  = $translator;
    }

    /**
     * @param Request   $request
     * @param Cart|null $cart
     * @Route({
     *     "fr": "/la-boutique",
     *     "en": "/en/shop"
     * }, name="shop")
     *
     * @return mixed|\Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction(Request $request, Cart $cart = null)
    {
        $priceCode = null;
        $country   = null;
        if ($request->cookies->has('PRICE')) {
            $priceCode = $this->productPriceCodeRepository->findOneBy(['id' => $request->cookies->get('PRICE')]);
            if (!$priceCode) {
                return $this->redirectToRoute('price_code_delete');
            }
        }
        $priceGroups    = $this->productPriceGroupRepository->findAll();
        $countryDefault = $this->shippingCountryRepository->findTvaByDefault();
        $config         = $this->shopConfigRepository->findOne();
        $shippingConfig = $this->shippingConfigRepository->findOne();

        if ($this->session->get('cart')) {
            /** @var Cart $cart */
            $cart     = $this->cartRepository->findOneBy(['id' => $this->session->get('cart')]);
            $products = $this->priceGroupWithCookie->findAllPublish($cart);
            /** @var CartCheckout $cartCheckout */
            if ($cart) {
                $cartCheckout = $cart->getCartCheckout();
                if ($cartCheckout) {
                    if ($cartCheckout->getPayedAt()) {
                        $cart = null;
                        $this->get('session')->set('cart', null);
                    }
                }
            }
        } else {
            $products = $this->priceGroupWithCookie->findAllPublish();
        }
        if ($cart) {
            $country = $this->shippingCountryRepository->findOneBy(['code' => $cart->getDeliveryAddress()->getCountry()]);
        }
        $form = $this->createForm(CartType::class, $cart, ['validation_groups' => ['Default', 'checkout']]);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Cart $cart */
            $cart  = $form->getData();
            $items = $cart->getItems();
            /** @var CartItem $item */
            foreach ($items as $item) {
                $variant = $item->getVariant();
                $item->setCart($cart);
                if ($variant->getPriceDiscount()) {
                    $item->setPrice($variant->getPriceDiscount());
                } else {
                    $item->setPrice($variant->getPrice());
                }
            }
            try {
                $shipping = $this->calculShipping->shippingTotalPrice($cart);
                $cart->setShipping($shipping['amount']);
                $cart->setShippingName($shipping['shippingName']);
                if ($priceCode) {
                    $cart->setGroupCode($priceCode->getCode());
                }
                $this->cartRepository->save($cart);
                $this->session->set('cart', $cart->getId()->toString());
                $contact = $this->contactRepository->findOne();

                return $this->paymentProviderManager->createPaymentProviderManager($contact, $cart);

            } catch (\Exception $e) {
                $form->addError(new FormError($e->getMessage()));
                $this->flashBag->add('error', $e->getMessage());
            }
        } elseif ($form->isSubmitted()) {
            $this->flashBag->add('error', 'Le formulaire n\'est pas rempli correctement !');
        }

        return $this->render(
            '@CpCreationTheme1/shop.html.twig',
            [
                'classMenu'      => 'black',
                'products'       => $products,
                'config'         => $config,
                'cart'           => $cart,
                'priceGroups'    => $priceGroups,
                'country'        => $country,
                'countryDefault' => $countryDefault,
                'shippingConfig' => $shippingConfig,
                'form'           => $form->createView(),
            ]
        );
    }

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route(path="/paiement/{id}/check", name="payment_check")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCheckAction(Request $request, Cart $cart)
    {

        return $this->render(
            '@CpCreationTheme1/payment/check.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $cart,
            ]
        );
    }

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route(path="/paiement/{id}/cb_etransactions", name="payment_cb_etransactions")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbEtransactionsAction(Request $request, Cart $cart)
    {
        $data = $this->etransactionsPayment->createData($cart);

        return $this->render(
            '@CpCreationTheme1/payment/cb.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $cart,
                'data'      => $data,
            ]
        );
    }


    /**
     * @param Request $request
     * @Route(path="/paiement/cb/retour", name="payment_cb_return")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbReturnAction(Request $request)
    {
        $code  = $request->query->get('Erreur');
        $ref   = $request->query->get('Ref');
        $error = null;
        if ($code === '00000') {
            $msg = $this->translator->trans('shop.return.success');
        } else {
            $cart = $this->cartRepository->findOneBy(['token' => $ref]);
            if (!$cart) {
                return $this->redirectToRoute('shop');
            }
            $cart->setToken();
            $this->cartRepository->save($cart);

            $msg   = $this->translator->trans('shop.return.echec');
            $error = $this->translator->trans('shop.return.error');
        }

        return $this->render(
            '@CpCreationTheme1/payment/cb_return.html.twig',
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route(path="/paiement/{id}/cb_monetico", name="payment_cb_monetico")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbMoneticoAction(Request $request, Cart $cart)
    {
        $data = $this->moneticoPayment->createData($cart);

        return $this->render(
            '@CpCreationTheme1/payment/cb.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $cart,
                'data'      => $data,
            ]
        );
    }

    /**
     * @param Request $request
     * @Route(path="/paiement/cb_monetico/retour/erreur", name="payment_cb_monetico_return_error")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbMoneticoReturnErrorAction(Request $request)
    {
        $msg   = $this->translator->trans('shop.return.echec');
        $error = $this->translator->trans('shop.return.error');

        return $this->render(
            '@CpCreationTheme1/payment/cb_return.html.twig',
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }

    /**
     * @param Request $request
     * @Route(path="/paiement/cb_monetico/retour/succes", name="payment_cb_monetico_return_success")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbMoneticoReturnSuccessAction(Request $request)
    {
        $error = null;
        $msg   = $this->translator->trans('shop.return.success');

        return $this->render(
            '@CpCreationTheme1/payment/cb_return.html.twig',
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }
}
