<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme1Bundle\Controller;

use CpCreation\VitiCore\Gite\Repository\GiteRepository;
use CpCreation\VitiCore\Newsletter\Repository\NewsletterRepository;
use CpCreation\VitiCore\Popup\Repository\PopupRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class HomepageController extends AbstractController
{

    private $popupRepository;
    private $newsletterRepository;
    private $giteRepository;

    public function __construct(PopupRepository $popupRepository,
        NewsletterRepository $newsletterRepository,
        GiteRepository $giteRepository
    ) {
        $this->popupRepository      = $popupRepository;
        $this->newsletterRepository = $newsletterRepository;
        $this->giteRepository       = $giteRepository;
    }

    /**
     * @Route({
     *     "fr": "",
     *     "en": "/en"
     * }, name="homepage")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $popup      = $this->popupRepository->findOneOrNull();
        $newsletter = $this->newsletterRepository->findLastNewsletter();
        $cottages   = $this->giteRepository->findAll();
        $subMenu    = null;
        if ($newsletter) {
            $subMenu = true;
        }

        return $this->render(
            '@CpCreationTheme1/homepage.html.twig',
            [
                'popup'      => $popup,
                'newsletter' => $newsletter,
                'subMenu'    => $subMenu,
                'cottages'   => $cottages,
            ]
        );
    }
}