<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme1Bundle\Controller;

use CpCreation\VitiCore\History\Repository\HistoryRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class HomeController extends AbstractController
{
    private $historyRepository;
    public function __construct(HistoryRepository $historyRepository)
    {
        $this->historyRepository = $historyRepository;
    }

    /**
     * @Route({
     *     "fr": "/la-maison",
     *     "en": "/en/house"
     * }, name="home")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $histories = $this->historyRepository->findBy(['disabled' => 0], ['position' => 'ASC']);

        return $this->render(
            '@CpCreationTheme1/home.html.twig',
            [
                'classMenu' => 'black',
                "histories" => $histories,
                'subMenu'   => true,
            ]
        );
    }
}