<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\Theme1Bundle\Controller;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\ContactType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\ReCaptcha;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Newsletter\Repository\NewsletterRepository;
use CpCreation\VitiCore\Popup\Repository\PopupRepository;
use CpCreation\VitiCore\Product\Repository\ProductRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Contracts\Translation\TranslatorInterface;

class ContactController extends AbstractController
{
    private $popupRepository;
    private $newsletterRepository;
    private $productRepository;
    private $contactRepository;
    private $reCaptcha;
    private $translator;
    private $mailer;

    public function __construct(PopupRepository $popupRepository,
        NewsletterRepository $newsletterRepository,
        ProductRepository $productRepository,
        ContactRepository $contactRepository,
        ReCaptcha $reCaptcha,
        TranslatorInterface $translator,
        \Swift_Mailer $mailer

    ) {
        $this->popupRepository      = $popupRepository;
        $this->newsletterRepository = $newsletterRepository;
        $this->productRepository    = $productRepository;
        $this->contactRepository    = $contactRepository;
        $this->reCaptcha            = $reCaptcha;
        $this->translator           = $translator;
        $this->mailer               = $mailer;
    }


    /**
     * @param Request $request
     *
     * @Route({
     *     "fr": "/contact",
     *     "en": "/en/contact"
     * }, name="contact")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction(Request $request)
    {
        $contact            = $this->contactRepository->findOne();
        $recaptchaKeyPublic = false;
        if ($contact->isRecaptcha()) {
            $recaptchaKeyPublic = $contact->getRecaptchaKeyPublic();
        }
        $form = $this->createForm(ContactType::class);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $data    = $form->getData();
            if (!$this->reCaptcha->verify($request->get('g-recaptcha-response'))) {
                $this->addFlash('error', $this->translator->trans('contact.form.recaptcha.error'));
            } else {
                $message = (new \Swift_Message('Prise de contact depuis le site '.$contact->getCompany()))
                    ->setTo($contact->getEmailToMessage())
                    ->setFrom($contact->getEmailFrom(), $contact->getCompany())
                    ->setReplyTo($data['email'], $data['lastname'])
                    ->setBody(
                        '
                    Nom : '.$data['lastname'].'<br/>
                    E-mail : '.$data['email'].'<br/>
                    Message : '.$data['message'].'<br/>
                ', 'text/html'
                    )
                    ->addPart(
                        'Nom : '.$data['lastname'].'E-mail : '.$data['email'].'Message : '.$data['message'].$contact->getCompany(), 'text/plain'
                    );

                if ($this->mailer->send($message)) {
                    $this->addFlash('success', $this->translator->trans('contact.form.success'));

                    return $this->redirectToRoute('contact');
                } else {
                    $this->addFlash('error', $this->translator->trans('contact.form.error'));
                }
            }
        }

        return $this->render(
            '@CpCreationTheme1/contact.html.twig',
            [
                'contact'            => $contact,
                'classMenu'          => 'black',
                'reCaptchaKeyPublic' => $recaptchaKeyPublic,
                'form'               => $form->createView(),
            ]
        );
    }
}