let showMoreList = document.querySelectorAll('.show-more-list');

let divGroupElems = document.querySelectorAll('.category-group-content');
divGroupElems.forEach((divGroupElem) => {
    divFirstMethod = divGroupElem.querySelector(".first-method");
    if (divFirstMethod) {
        divGroupElem.style.minHeight = divFirstMethod.offsetHeight + "px";
    }
});
showMoreList.forEach((showMore) => {
    showMore.addEventListener('click', function (event) {
        event.preventDefault();
        let active = false;
        let divGroup = showMore.parentNode.querySelector('.category-group-content');
        if (divGroup.classList.contains('active')) {
            active = true;
        }
        let height = 0;
        showMoreList.forEach((showMore) => {
            let divGroupElem = showMore.parentNode.querySelector('.category-group-content');
            if (divGroupElem.classList.contains('active')) {

                showMore.querySelector('span').innerHTML = showMore.querySelector('a').getAttribute('data-text-open');
                divGroupElem.classList.remove('active');
                divGroupElem.style.maxHeight = divGroupElem.style.minHeight;
            }
            divGroupElem.querySelectorAll(":scope > div").forEach((div, index) => {
                height = height + div.offsetHeight;
            });
        });
        let textOpen = event.target.getAttribute('data-text-open');
        let textClose = event.target.getAttribute('data-text-close');
        if (active) {
            divGroupElem.style.maxHeight = divGroupElem.style.minHeight;
            event.target.querySelector('span').innerHTML = textOpen;
        } else {
            var scrollTop = $(window).scrollTop(),
                elementOffset = divGroup.offsetTop,
                distance = (scrollTop - elementOffset);
            divGroup.classList.add('active');
            event.target.querySelector('span').innerHTML = textClose;
            setTimeout(function () {
                divGroup.style.maxHeight = height + "px";
            }, 200);

        }
    }, false);
});

function isInViewport(el) {
    const rect = el.getBoundingClientRect();
    return (
        rect.top >= document.querySelector('#navbar').offsetHeight &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)

    );
}
