<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Season\Model\Season;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class SeasonController extends Controller
{
    /**
     * @Route({
     *     "fr": "/saisons",
     *     "en": "/en/seasons"
     * }, name="seasons")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Exception
     */
    public function indexAction()
    {
        $seasons = $this->getDoctrine()->getRepository(Season::class)->findBy([],['position' => 'ASC']);

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/season.html.twig',
            [
                'classMenu' => 'black',
                'seasons'     => $seasons
            ]
        );
    }
}