<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Contact\Model\Contact;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;

class LegalController extends Controller
{

    /**
     * @Route({
     *     "fr": "/mentions-legales",
     *     "en": "/en/legals-mentions"
     * }, name="legals")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $contact = $this->getDoctrine()->getRepository(Contact::class)->findOne();

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/legal.html.twig',
            [
                'contact'   => $contact,
                'classMenu' => 'black',
            ]
        );
    }
}