<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Contact\Model\Label;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class FooterController extends Controller
{
    /**
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $contact = $this->getDoctrine()->getRepository(Contact::class)->findOne();
        $labels  = $this->getDoctrine()->getRepository(Label::class)->findBy([], ['position' => 'ASC']);

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/_footer.html.twig',
            [
                'contact' => $contact,
                'labels'  => $labels,
            ]
        );
    }
}