const routes = require('../../../../../../../public/js/fos_js_routes.json');
import Routing from '../../../../../../friendsofsymfony/jsrouting-bundle/Resources/public/js/router.min.js';
import * as Toastr from 'toastr';

Routing.setRoutingData(routes);

let $collectionHolder;

jQuery(document).ready(function () {

    if (document.querySelector('#cart_items')) {
        // Get the ul that holds the collection of tags
        $collectionHolder = $('#cart_items');
        if ($collectionHolder.length) {
            if ($collectionHolder.html().length > 0) {
                $('.cart-empty').hide();
                totalProductsPrice();
            }
        }
        $('[name^="cart[deliveryAddress]"]').each(function (i, el) {

            if (el.getAttribute('type') != "checkbox") {
                $(this).removeAttr('required');
            }

        });
        // count the current form inputs we have (e.g. 2), use that as the new
        // index when inserting a new item (e.g. 2)
        $collectionHolder.data('index', $collectionHolder.find(':input').length);

        let $promo = $('#cart_promo');
        if ($promo.length) {
            calculPromo($promo.val())
        }

        if ($('#cart_deliveryAddress_differentAddress').is(':checked')) {
            $('.form-address').show();
            $('[name^="cart[deliveryAddress]"]').each(function (i, el) {
                if (el.getAttribute('type') != "checkbox") {
                    $(this).attr('required', 'required');
                }

            });
        }
        if ($('#cart_invoiceAddress_country').val() == 'FR') {
            $('#cart_invoiceAddress_city').prop('readonly', true)
        }
        if ($('#cart_deliveryAddress_country').val() == 'FR') {
            $('#cart_deliveryAddress_city').prop('readonly', true)
        }

        $('#cart_invoiceAddress_postalCode,#cart_deliveryAddress_postalCode').keyup(function (event) {
            let postal = null;
            let city = null;
            if (event.target.id == 'cart_invoiceAddress_postalCode') {
                postal = $('#output_postal_invoice');
                city = $('#cart_invoiceAddress_city')
            } else if (event.target.id == 'cart_deliveryAddress_postalCode') {
                postal = $('#output_postal_delivery');
                city = $('#cart_deliveryAddress_city')
            }
            postal.hide();
            postal.empty();
            if ($(this).val().length > 4) {
                let sortCities = [];
                $.vicopo($(this).val(), function (input, cities) {
                    Object.keys(cities).forEach(function (key) {
                        sortCities[cities[key]['city']] = cities[key]['code'];
                    });
                    let $i = 0;
                    Object.keys(sortCities).sort().forEach(function (key) {
                        if ($i == 0) {
                            postal.show();
                        }
                        let a = '<a href="#" data-scroll-ignore data-city="' + key + '">' + sortCities[key] + ' ' + key + '</a>';
                        postal.append(a);
                        $i++;
                    });
                });
            } else {
                city.val(null);
            }
        });
        $('#output_postal_invoice,#output_postal_delivery').on('click', 'a', function (e) {
            let city = $(this).data('city');
            if ($(this).parent().attr('id') == 'output_postal_invoice') {
                $('#cart_invoiceAddress_city').val(city);
                $('#output_postal_invoice').hide();
            } else if ($(this).parent().attr('id') == 'output_postal_delivery') {
                $('#cart_deliveryAddress_city').val(city);
                $('#output_postal_delivery').hide();

            }
            totalProductsPrice();
            e.preventDefault();
            e.stopPropagation();
        });
        let deliveryMethods = document.querySelectorAll('.input_cart_deliveryMethod');
        if (deliveryMethods) {
            deliveryMethods.forEach((deliveryMethod) => {
                deliveryMethod.addEventListener('click', () => {
                    deliveryMethods.forEach((deliveryMethodBis) => {
                        if (deliveryMethodBis != deliveryMethod) {
                            deliveryMethodBis.checked = false;
                        }
                    });
                    totalProductsPrice();
                });
            });
        }
    }
});

$('#cart_promo').on('change', function () {
    let code = $(this).val();
    calculPromo(code)
});

$('#cart_invoiceAddress_postalCode').on('change', function () {
    totalProductsPrice();
});
$('#cart_deliveryAddress_postalCode').on('change', function () {
    totalProductsPrice();
});
$('.button-shop').on('click', function (e) {
    // prevent the link from creating a "#" on the URL
    e.preventDefault();

    let item = $(this).attr('data-item');
    let price = $(this).attr('data-price');
    let product = $(this).attr('data-product');
    let elQty = $('.variant-qty[data-item="' + item + '"]');
    let qty = elQty[0].value;
    let typeVariant = $('.variant-type[data-product="' + product + '"] :selected').text();
    let typeValue = $('.variant-type[data-product="' + product + '"] :selected').val();
    if (!typeValue) {
        if (!document.querySelector('.variant[data-product="' + product + '"]')) {

            Toastr.warning(Translator.trans('shop.error.volume', {}, 'messages'));
            return;
        }
    }
    if (typeVariant == '') {
        typeVariant = $(this).parent().children('.article-info').find('.variant-name').text();
    }
    let name = $('.article-info[data-product="' + product + '"]').find('.cuvee-name').text();
    name = name.replace(/(<([^>]+)>)/ig, "");
    let quality = $('.article-info[data-product="' + product + '"]').find('.article-quality').text();
    if (qty <= 0) {
        Toastr.warning(Translator.trans('shop.error.quantity', {}, 'messages'));

        return;

    } else {
        $('.variant-qty').each(function (i, obj) {
            $('.variant-qty').foundation('removeErrorClasses', $(this));
            $('.variant-qty').val(0);
        });
        $('.cart-empty').hide();
        if (!$(this).is('[data-soldout]')) {
            let textAddToCart = $('section.shop').attr('data-adding-to-cart');
            addItemForm($collectionHolder, item, qty, price);
            Toastr.success(textAddToCart + ' ' + qty + ' ' + name + ' ' + quality);
        }

    }
});

$(".variant-type").change(function () {
    let optionSelected = $("option:selected", this);
    let product = $(this).data('product');
    let item = optionSelected.val();
    let price = parseFloat(optionSelected.data('price') * 100 / 10000).toFixed(2);
    let oldPrice = optionSelected.data('old-price');
    let elQty = $('.variant-qty[data-product="' + product + '"]');
    elQty[0].setAttribute('data-item', item);
    let elButton = $('.button-shop[data-product="' + product + '"]');
    if (optionSelected.data('soldout')) {
        elButton.attr('data-soldout', 'data-soldout');
        $(this).parent().parent().find('.variant-qty').attr('disabled', 'disabled');
        $(this).parent().parent().parent().parent().find('.ribbon').removeClass('hidden');
        $(this).parent().parent().parent().parent().find('.ribbon').removeClass('promo');
        $(this).parent().parent().parent().parent().find('.ribbon').addClass('soldout');
        console.log($('section .shop').attr('data-text-soldout'));
        $(this).parent().parent().parent().parent().find('.ribbon span').text($('section.shop').attr('data-text-soldout'));
    } else if (optionSelected.data('discount')) {
        $(this).parent().parent().parent().parent().find('.ribbon').removeClass('hidden');
        $(this).parent().parent().parent().parent().find('.ribbon').removeClass('soldout');
        $(this).parent().parent().parent().parent().find('.ribbon').addClass('promo');
        $(this).parent().parent().parent().parent().find('.ribbon span').text($('section.shop').attr('data-text-promo'));
        elButton.removeAttr('data-soldout');
        $(this).parent().parent().find('.variant-qty').removeAttr('disabled');
    } else {
        $(this).parent().parent().parent().parent().find('.ribbon').addClass('hidden');
        elButton.removeAttr('data-soldout');
        $(this).parent().parent().find('.variant-qty').removeAttr('disabled');
    }
    $('.variant-qty').each(function (i, obj) {
        $('.variant-qty').foundation('removeErrorClasses', $(this));
    });


    elButton[0].setAttribute('data-item', item);
    elButton[0].setAttribute('data-price', optionSelected.data('price'));

    $(this).parent().parent().find(".variant-qty").data('item', item);
    if (oldPrice == null) {
        $(this).parent().parent().parent().find(".variant-price").text(price + ' €');
    } else {

        let old = optionSelected.data('old-price').match(/\d+/)[0];
        old = parseFloat(old / 100).toFixed(2);
        $(this).parent().parent().parent().find(".variant-price").html('<span class="old-price">' + old + ' €</span> ' + price + ' €');

    }

});
$(document).on('click', '.delete-cart-row', function (e) {
    $(e.target).parents('.form-group:first').remove();
    if ($('#cart_items').is(':empty')) {
        $('.cart-empty').show();
    }
    totalProductsPrice();
});

$('#cart_items').on('change', '.cart-item-quantity', function (e) {
    let item = $(this).data('item');
    let quantity = 0;
    let price = $('.cart-item-price[data-item="' + item + '"]').attr('data-price');
    if ($(this).val()) {
        quantity = parseInt($(this).val());
    }

    let totalItem = parseFloat(price * quantity).toFixed(2);
    $('.cart-item-total[data-item="' + item + '"]').text(totalItem + ' €');
    totalProductsPrice();
});

$('#cart_deliveryAddress_differentAddress').on('click', function (e) {
    if ($(this).is(':checked')) {
        $('.form-address').show();
        $('[name^="cart[deliveryAddress]"]').each(function (i, el) {
            if (el.getAttribute('type') != "checkbox") {
                $(this).attr('required', 'required');
            }

        });
    } else {
        $('.form-address').hide();
        $('[name^="cart[deliveryAddress]"]').each(function (i, el) {
            if (el.getAttribute('type') != "checkbox") {
                $(this).removeAttr('required');
            }

        });
    }
    totalProductsPrice();
});

function addItemForm($collectionHolder, item, quantity, price) {
    // Get the data-prototype explained earlier
    let prototype = $collectionHolder.data('prototype');

    // get the new index
    let index = $collectionHolder.data('index');

    let newForm = prototype;

    newForm = newForm.replace(/__name__/g, index);
    let prevItem = $('.cart-item-quantity[data-item="' + item + '"]');
    if (prevItem[0]) {
        let prevQuantity = prevItem[0].value;
        let totalQuantity = parseInt(prevQuantity) + parseInt(quantity);
        prevItem[0].value = totalQuantity;
        price = parseFloat(parseInt(price) * 100 / 10000).toFixed(2);
        let totalItem = parseFloat(price * totalQuantity).toFixed(2);
        let prevTotal = $('.cart-item-total[data-item="' + item + '"]');
        prevTotal.text(totalItem + ' €');
    } else {
        // increase the index with one for the next item
        $collectionHolder.data('index', index + 1);

        // Display the form in the page in an li, before the "Add a tag" link li
        let $newFormLi = $('#cart_items').append(newForm);
        $newFormLi.find('#cart_items_' + index + '_quantity').val(quantity);
        $newFormLi.find('#cart_items_' + index + '_quantity').attr('data-item', item);
        $newFormLi.find('#cart_items_' + index + '_variant').val(item);
        $newFormLi.find('#cart_items_' + index + '_variant').attr('data-item', item);
        $newFormLi.find('#cart_items_' + index + '_variant').val(item);
        $newFormLi.find('#cart_items_' + index + '_name').text($newFormLi.find('#cart_items_' + index + '_variant option[value=' + item + ']').text());
        price = parseFloat(parseInt(price) * 100 / 10000).toFixed(2);
        let totalItem = parseFloat(price * quantity).toFixed(2);

        $newFormLi.find('#cart_items_' + index + '_price').text(price + ' €');
        $newFormLi.find('#cart_items_' + index + '_price').attr('data-item', item);
        $newFormLi.find('#cart_items_' + index + '_price').attr('data-price', price);

        $newFormLi.find('#cart_items_' + index + '_total').attr('data-item', item);
        $newFormLi.find('#cart_items_' + index + '_total').text(totalItem + ' €');

    }
    totalProductsPrice();
}

function totalProductsPrice() {
    let quantity = 0;
    let discountValue = $('.value-discount')[0].getAttribute('data-value');

    $('.cart-item-total').each(function (i, obj) {
        quantity = quantity + parseFloat($(this).html());
    });
    let discount = parseFloat(quantity * discountValue).toFixed(2);
    let total = quantity - discount;
    calculShiping(parseFloat(total).toFixed(2));
    $('.total-products-price').text(parseFloat(quantity).toFixed(2));
    $('.total-order-products').text(parseFloat(quantity).toFixed(2));


}

function calculShiping($total) {
    $total = parseFloat($total);
    let form = $('#cart_items_form');
    $.ajax({
        type: 'POST',
        url: Routing.generate('promo_price'),
        dataType: 'json',
        data: form.serializeArray(),
        success: function (result) {
            $total = $total - parseFloat(result / 100);
            $('.row-degressive').show();
            $('.value-degressive').attr("data-value", parseFloat(result / 100));
            $('.value-degressive').text(parseFloat(-result / 100).toFixed(2));

            return;
        },
        error: function () {
            $('.row-degressive').hide();
            $('.value-degressive').attr("data-value", 0);

            return;
        },
        complete: function () {
            $.ajax({
                type: 'POST',
                url: Routing.generate('calcul_shipping'),
                dataType: 'json',
                data: form.serializeArray(),
                success: function (result) {
                    $('.alert-shipping-box').hide();
                    let shipping = parseFloat(result / 100);
                    $('.total-order-shipping').text(parseFloat(shipping).toFixed(2));
                    $total = $total + shipping;
                    $('.total-order-total').text(parseFloat($total).toFixed(2));
                    if (document.querySelector('.tax-value')) {
                        let tax = $('.tax-value').data('value');
                        let totalTax = $total * tax;
                        $('.tax-value').text(parseFloat(totalTax).toFixed(2));
                        let totalTTC = totalTax + $total;
                        $('.total-order-total-ttc').text(parseFloat(totalTTC).toFixed(2));
                    }
                    return;
                },
                error: function (result) {
                    $('.total-order-shipping').html('-');
                    $('.alert-shipping-box').show();
                    $('.alert-shipping').html(result.responseJSON);
                    $('.total-order-total').text(parseFloat($total).toFixed(2));
                    return;
                }
            });
        }
    });

}

function calculPromo(code) {
    $.ajax({
        type: 'POST',
        url: Routing.generate('promo_code'),
        dataType: 'json',
        data: 'code=' + code,
        success: function (result) {
            $('.row-discount').show();
            $('.value-discount').attr("data-value", result);
            $('.value-discount').text(result * 100);
            $('.verif-promo').html(' <i class="fas fa-check-circle fa-2x"></i>');
            totalProductsPrice();
            return;
        },
        error: function () {
            $('.row-discount').hide();
            $('.value-discount').attr("data-value", 0);
            if ($('#cart_promo').val().length > 0) {
                $('.verif-promo').html('<i class="fas fa-times fa-2x"></i>');
            } else {
                $('.verif-promo').html('');
            }
            totalProductsPrice();
            return;
        }
    });
}
