<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\EventListener;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\Routing\RouterInterface;

class VerifyListener
{
    private $session;
    private $router;
    private $request;

    public function __construct(SessionInterface $session, RouterInterface $router, RequestStack $request)
    {
        $this->session = $session;
        $this->router  = $router;
        $this->request = $request;
    }

    public function onKernelRequest(GetResponseEvent $event)
    {
        if (preg_match('/baidu|dareboost|bingbot|facebookexternalhit|googlebot|-google|ia_archiver|msnbot|naverbot|pingdom|seznambot|slurp|teoma|twitter|yandex|yeti/i', $_SERVER['HTTP_USER_AGENT'])) {
            return;
        }

        $referer  = $this->request->getCurrentRequest()->headers->get('referer');
        $baseUrl  = $this->request->getCurrentRequest()->getSchemeAndHttpHost().'/';
        $lastPath = substr($referer, strpos($referer, $baseUrl) + strlen($baseUrl));

        if ($lastPath === 'verification-age' || $lastPath === 'en/check-age') {
            $this->session->set('verify', true);
        }

        if ($this->request->getCurrentRequest()->attributes->get('_route') != 'verify' &&
            ((strpos($this->request->getCurrentRequest()->getPathInfo(), 'request') != 1)) && (strpos($this->request->getCurrentRequest()->getPathInfo(), '.well-known') != 1)) {
            if (!$this->session->get('verify')) {
                $response = new RedirectResponse($this->router->generate('verify'));
                $event->setResponse($response);
            }
        }
    }
}