<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\CartType;
use CpCreation\VitiCore\Cart\Model\Cart;
use CpCreation\VitiCore\Cart\Model\CartCheckout;
use CpCreation\VitiCore\Cart\Model\CartItem;
use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Product\Model\ProductPriceCode;
use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Product\Model\ProductTax;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;
use CpCreation\VitiCore\Shop\Model\ShopConfig;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Form\FormError;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class ShopController extends Controller
{

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route({
     *     "fr": "/la-boutique",
     *     "en": "/en/shop"
     * }, name="shop")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction(Request $request, Cart $cart = null)
    {
        if ($request->cookies->has('PRICE')) {
            $priceCode = $this->getDoctrine()->getRepository(ProductPriceCode::class)->findOneBy(['id' => $request->cookies->get('PRICE')]);
            if (!$priceCode) {
                return $this->redirectToRoute('price_code_delete');
            }
        }
        $priceGroups    = $this->getDoctrine()->getRepository(ProductPriceGroup::class)->findAll();
        $products       = $this->get('viti-core.pricegroup_cookie')->findAllPublish();
        $taxDefault     = $this->getDoctrine()->getRepository(ProductTax::class)->findOneBy(['byDefault' => true]);
        $config         = $this->getDoctrine()->getRepository(ShopConfig::class)->findOne();
        $shippingConfig = $this->getDoctrine()->getRepository(ShippingConfig::class)->findOne();
        if ($this->get('session')->get('cart')) {
            $cart = $this->getDoctrine()->getRepository(Cart::class)->findOneBy(['id' => $this->get('session')->get('cart')]);
            /** @var CartCheckout $cartCheckout */
            if ($cart) {
                $cartCheckout = $cart->getCartCheckout();
                if ($cartCheckout) {
                    if ($cartCheckout->getPayedAt()) {
                        $cart = null;
                        $this->get('session')->set('cart', null);
                    }
                }
            }
        }

        $form = $this->createForm(CartType::class, $cart);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Cart $cart */
            $cart  = $form->getData();
            $items = $cart->getItems();
            /** @var CartItem $item */
            foreach ($items as $item) {
                $variant = $item->getVariant();
                $item->setCart($cart);
                if ($variant->getPriceDiscount()) {
                    $item->setPrice($variant->getPriceDiscount());
                } else {
                    $item->setPrice($variant->getPrice());
                }
            }
            try {
                $shipping = $this->get('viticore_calcul_shipping')->shippingTotalPrice($cart);
                $cart->setShipping($shipping);
                $this->getDoctrine()->getManager()->persist($cart);
                $this->getDoctrine()->getManager()->flush();
                $this->get('session')->set('cart', $cart->getId()->toString());
                $contact = $this->getDoctrine()->getRepository(Contact::class)->findOne();

                return $this->get('viti-core.provider.payment_manager')->createPaymentProviderManager($contact, $cart);

            } catch (\Exception $e) {
                $form->addError(new FormError($e->getMessage()));
                $this->get('session')->getFlashBag()->add('error', $e->getMessage());
            }
        } elseif ($form->isSubmitted()) {
            $this->get('session')->getFlashBag()->add('error', 'Le formulaire n\'est pas rempli correctement !');
        }

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/shop.html.twig',
            [
                'classMenu'      => 'black',
                'products'       => $products,
                'config'         => $config,
                'priceGroups'    => $priceGroups,
                'taxDefault'     => $taxDefault,
                'shippingConfig' => $shippingConfig,
                'form'           => $form->createView(),
            ]
        );
    }

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route(path="/paiement/{id}/check", name="payment_check")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCheckAction(Request $request, Cart $cart)
    {

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/payment/check.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $cart,
            ]
        );
    }

    /**
     * @param Request $request
     * @param Cart    $cart
     * @Route(path="/paiement/{id}/cb", name="payment_cb")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbAction(Request $request, Cart $cart)
    {
        $data = $this->get('viti-core.payment.etransactions')->createData($cart);

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/payment/etransactions.html.twig',
            [
                'classMenu' => 'black',
                'cart'      => $cart,
                'data'      => $data,
            ]
        );
    }

    /**
     * @param Request $request
     * @Route(path="/paiement/cb/retour", name="payment_cb_return")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function paymentCbReturnAction(Request $request)
    {
        $code  = $request->query->get('Erreur');
        $error = null;
        if ($code === '00000') {
            $msg = $this->get('translator')->trans('shop.return.success');
        } else {
            $msg   = $this->get('translator')->trans('shop.return.echec');
            $error = $this->get('translator')->trans('shop.return.error');
        }

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/payment/etransactions.html.twig',
            [
                'classMenu' => 'black',
                'msg'       => $msg,
                'error'     => $error,
            ]
        );
    }
}
