<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use CpCreation\VitiCore\Library\Model\Library;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;

class LibraryController extends Controller
{
    /**
     * @Route({
     *     "fr": "/galerie",
     *     "en": "/en/gallery"
     * }, name="library")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Exception
     */
    public function indexAction()
    {
        $libraries = $this->getDoctrine()->getRepository(Library::class)->findBy([], ['position' => 'ASC']);
        $instagram = $this->get('viti-core.provider.socialnetwork_manager')->createSocialNetworkProviderManager('instagram', 12);

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/library.html.twig',
            [
                'classMenu' => 'black',
                'libraries' => $libraries,
                'instagram' => $instagram,
            ]
        );
    }
}