<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\History\Model\History;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;

class HomeController extends Controller
{

    /**
     * @Route({
     *     "fr": "/la-maison",
     *     "en": "/en/house"
     * }, name="home")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $histories = $this->getDoctrine()->getRepository(History::class)->findBy(['disabled' => 0], ['position' => 'ASC']);

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/home.html.twig',
            [
                'classMenu' => 'black',
                "histories" => $histories,
                'subMenu'   => true,
            ]
        );
    }
}