<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Depot\Model\Category;
use CpCreation\VitiCore\Event\Model\Event;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class DepotSalonController extends Controller
{
    /**
     * @param Request $request
     *
     *  * @Route({
     *     "fr": "/ou-nous-trouver",
     *     "en": "/en/where-to-find-us"
     * }, name="find-us")
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        $categories = $this->getDoctrine()->getRepository(Category::class)->findBy([], ['position' => 'ASC']);
        $salons     = $this->getDoctrine()->getRepository(Event::class)->findBy([], ['beginAt' => 'ASC']);

        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/depotsalon.html.twig',
            [
                'classMenu'  => 'black',
                'categories' => $categories,
                'salons'     => $salons,
            ]
        );
    }

}