import loadGoogleMapsApi from 'load-google-maps-api';

if (document.getElementById('map')) {
    let options = {key: process.env.APP_GOOGLEMAP};
    let querySelector = document.getElementById('map');
    let lat = parseFloat(querySelector.getAttribute('data-lat'));
    let lng = parseFloat(querySelector.getAttribute('data-lng'));
    loadGoogleMapsApi(options).then(function (googleMaps) {
        let map = new googleMaps.Map(querySelector, {
            center: {
                lat: lat,
                lng: lng
            },
            styles: [

                {
                    featureType: "poi.business",
                    elementType: "labels",
                    stylers: [
                        {visibility: "off"}
                    ]
                }
            ],
            zoom: 17,
            disableDefaultUI: true,
            mapTypeId: 'hybrid'
        });
        let myLatlng = new google.maps.LatLng(lat, lng);
        let company = querySelector.getAttribute('data-company');
        var marker = new google.maps.Marker({
            position: myLatlng,
            map: map,
            title: company,

        });
        var infowindow = new google.maps.InfoWindow({
            content: company,
            size: new google.maps.Size(100, 100)
        });

        infowindow.open(map, marker);
        marker.setMap(map);
    });
}

let options = {key: process.env.APP_GOOGLEMAP};
let depotContainers = document.querySelectorAll('.depot-container');
let mapsGoogle = [];
if (depotContainers) {
    depotContainers.forEach(function(container, index) {
        loadGoogleMapsApi(options).then(function (googleMaps) {
            mapsGoogle[index] = (new googleMaps.Map(container.querySelector('.depotMap'), {
                center: {lat: 46.8619641, lng: 1.6578633},
                zoom: 6,
                disableDefaultUI: true
            }));
            let markers = [];
            container.querySelectorAll('.depot').forEach(function (depot) {
                let lng = depot.getAttribute('data-lng');
                let lat = depot.getAttribute('data-lat');
                let name = depot.getAttribute('data-name');
                let marker = new google.maps.Marker({
                    position: new google.maps.LatLng(lat,lng),
                    animation: google.maps.Animation.DROP,
                    map: mapsGoogle[index],
                    optimized: false,
                    icon: {
                        url: '/images/icon-map.png',
                        size: new google.maps.Size(35, 35),
                        optimized: false
                    }
                });
                marker.infowindow = new google.maps.InfoWindow();
                marker.infowindow.setContent(name);
                marker.addListener('click', function () {
                    marker.infowindow.open(mapsGoogle[index], marker);
                });
                markers.push(marker);
            });
        });
    });

}