<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Gite\Model\Gite;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

class CottageController extends Controller
{
    /**
     * @param Gite $gite
     *
     * @Route({
     *     "fr": "/gite/{slug}",
     *     "en": "/en/gite/{slug}"
     * }, name="cottage")
     * @ParamConverter("gite", converter="translation_converter")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Gite $gite)
    {
        return $this->render(
            '@CpCreationSkeleton/'.$this->getParameter('theme').'/cottage.html.twig',
            [
                'classMenu' => 'black',
                'cottage'   => $gite,
            ]
        );
    }
}