<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Season\Model\Season;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class SeasonController extends Controller
{
    /**
     * @Route({
     *     "fr": "/saisons",
     *     "en": "/en/seasons"
     * }, name="seasons")
     * @Template("@CpCreationSkeleton/theme1/season.html.twig")
     *
     * @return array
     * @throws \Exception
     */
    public function indexAction()
    {
        $seasons = $this->getDoctrine()->getRepository(Season::class)->findBy([],['position' => 'ASC']);

        return [
            'classMenu' => 'black',
            'seasons'     => $seasons
        ];
    }
}