<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\News\Model\Category;
use CpCreation\VitiCore\News\Model\News;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class NewsController extends Controller
{

    /**
     * @Route({
     *     "fr": "/les-actualites",
     *     "en": "/en/news"
     * }, name="news")
     * @Template("@CpCreationSkeleton/theme1/news.html.twig")
     */
    public function indexAction(Request $request)
    {
        $subMenu        = false;
        $news           = $this->getDoctrine()->getRepository(News::class)->findAvailableAndPublish();
        $categoriesNews = $this->getDoctrine()->getRepository(Category::class)->findBy([], ['position' => 'ASC']);
        if ($categoriesNews) {
            $subMenu = true;
        }

        return [
            'classMenu'      => 'black',
            'subMenu'        => $subMenu,
            'news'           => $news,
            'categoriesNews' => $categoriesNews,
        ];
    }

    /**
     * @param Category $category
     * @Route({
     *     "fr": "/les-actualites/{slug}",
     *     "en": "/the-news/{slug}"
     * }, name="news_category")
     * @ParamConverter("category", converter="translation_converter")
     * @Template("@CpCreationSkeleton/theme1/news_category.html.twig")
     *
     * @return array
     */
    public function categoryAction(Category $category)
    {
        $categoriesNews = $this->getDoctrine()->getRepository(Category::class)->findBy([], ['position' => 'ASC']);

        return [
            'classMenu'      => 'black',
            'subMenu'        => true,
            'category'       => $category,
            'categoriesNews' => $categoriesNews,
        ];
    }
}