<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site\Controller;
use CpCreation\VitiCore\Gite\Model\Gite;
use CpCreation\VitiCore\Locale\Model\Locale;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class MenuController extends Controller
{
    /**
     * @Template("@CpCreationSkeleton/theme1/_menu.html.twig")
     *
     * @return array
     */
    public function indexAction()
    {
        $cottages = $this->getDoctrine()->getRepository(Gite::class)->findAll();
        $locales  = $this->getDoctrine()->getRepository(Locale::class)->findAll();

        return [
            'locales' => $locales,
            'cottages' => $cottages
        ];
    }
}