<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use CpCreation\VitiCore\Library\Model\Library;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class LibraryController extends Controller
{
    /**
     * @Route({
     *     "fr": "/galerie",
     *     "en": "/en/gallery"
     * }, name="library")
     * @Template("@CpCreationSkeleton/theme1/library.html.twig")
     *
     * @return array
     * @throws \Exception
     */
    public function indexAction()
    {
        $libraries = $this->getDoctrine()->getRepository(Library::class)->findBy([],['position' => 'ASC']);
        $instagram     = $this->get('viti-core.provider.socialnetwork_manager')->createSocialNetworkProviderManager('instagram', 12);

        return [
            'classMenu' => 'black',
            'libraries' => $libraries,
            'instagram'     => $instagram
        ];
    }
}