<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Contact\Model\Contact;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

use Symfony\Component\Routing\Annotation\Route;

class LegalController extends Controller
{

    /**
     * @Route({
     *     "fr": "/mentions-legales",
     *     "en": "/en/legals-mentions"
     * }, name="legals")
     * @Template("@CpCreationSkeleton/theme1/legal.html.twig")
     *
     * @return array
     * @throws \Doctrine\ORM\NoResultException
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $contact = $this->getDoctrine()->getRepository(Contact::class)->findOne();

        return [
            'contact' => $contact,
            'classMenu' => 'black'
        ];
    }
}