<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\SkeletonBundle\Controller;

use CpCreation\VitiCore\Gite\Model\Gite;
use CpCreation\VitiCore\Newsletter\Model\Newsletter;
use CpCreation\VitiCore\Popup\Model\Popup;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;

class HomepageController extends Controller
{

    /**
     * @Route({
     *     "fr": "",
     *     "en": "/en"
     * }, name="homepage")
     * @Template("@CpCreationSkeleton/theme1/homepage.html.twig")
     *
     * @return array
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $popup = $this->getDoctrine()->getRepository(Popup::class)->findOneOrNull();
        $newsletter = $this->getDoctrine()->getRepository(Newsletter::class)->findLastNewsletter();
        $cottages = $this->getDoctrine()->getRepository(Gite::class)->findAll();
        $subMenu = null;
        if ($newsletter)
        {
            $subMenu = true;
        }

        return [
            'popup' => $popup,
            'newsletter' => $newsletter,
            'subMenu' => $subMenu,
            'cottages' => $cottages
        ];
    }
}